# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           90secondportraits
Version:        1.01b
Release:        alt1_6
Summary:        Speed painting game: paint portraits in 90 seconds!
Group:          Games/Arcade
License:        zlib and CC-BY-SA 4.0 and CC-BY
URL:            https://tangramgames.dk/games/90secondportraits/
# Repacked with submodules from https://github.com/SimonLarsen/90-Second-Portraits
Source0:        %{name}-%{version}.tar.xz
Source1:        %{name}-128.png
Source2:        README.md
Patch0:         90secondportraits-1.01b-mga-Support-fkeys-and-numpad-for-scaling.patch

BuildArch:      noarch
BuildRequires:  zip
Requires:       love0.10
Source44: import.info

%description
Time is money and you have neither!
In 90 Second Portraits you're paying the bills by speed painting
portraits of bypassing customers!

You have 90 seconds to paint the customer and his/her preferred background.
Your work day ends after 5 customers!

%files
%doc CREDITS.txt LICENSE.txt README.md
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/%{name}.love
%{_iconsdir}/hicolor/*/apps/%{name}.png

#----------------------------------------------------------------------------

%prep
%setup -q
%patch0 -p1

cp %{_sourcedir}/README.md .

%build
# Create .love archive
zip -9 -q -r %{name}.love .

# Launcher script
cat > %{name}.sh << EOF
#!/bin/sh
love0.10 %{_gamesdatadir}/%{name}/%{name}.love
EOF

# Desktop entry
cat > %{name}.desktop << EOF
[Desktop Entry]
Name=90 Second Portraits
GenericName=Speed painting
Comment=Speed painting game: paint portraits in 90 seconds!
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;ArcadeGame;
EOF

%install
install -D -m 644 %{name}.love %{buildroot}%{_gamesdatadir}/%{name}/%{name}.love
install -D -m 755 %{name}.sh %{buildroot}%{_gamesbindir}/%{name}
install -D -m 644 %{name}.desktop %{buildroot}%{_datadir}/applications/%{name}.desktop
install -D -m 644 %{_sourcedir}/%{name}-128.png %{buildroot}%{_iconsdir}/hicolor/128x128/apps/%{name}.png


%changelog
