Group: Publishing
# BEGIN SourceDeps(oneline):
BuildRequires: texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 27

Summary:	A Tool for manipulating BibTeX data bases
Name:		BibTool
Version:	2.68
Release:	alt2_%autorelease
Source0:	https://github.com/ge-ne/bibtool/releases/download/BibTool_2_68/BibTool-%{version}.tar.gz
Source1:	https://github.com/ge-ne/bibtool/releases/download/BibTool_2_68/BibTool-%{version}.tar.gz.asc
# Imported from public key servers; author provides no fingerprint!
Source2:	gpgkey-E2A609830CE1675666671B86EA2168BE699213A2.gpg
URL:		http://www.gerd-neugebauer.de/software/TeX/BibTool/
# Upstream patches:
Patch0:		0001-old-font-commands-added.patch
Patch1:		0001-support-for-make-check-fixed.patch
# Upstreambale patches:
Patch2:		0001-fix-incompatible-pointer-types.patch
# Fedora specific patches:
Patch3:		0001-build-BibTool-against-system-regex.patch
Patch4:		0001-fix-duplicate-case-fix.patch
License:	GPL-2.0-or-later AND CC-BY-SA-3.0
BuildRequires:	gcc
BuildRequires:	tex(latex) texlive texlive-collection-basic texlive-dist texlive texlive-collection-basic texlive-dist tex(luatex85.sty)
BuildRequires:	gnupg2
# make check requires (standard in the Fedora buildroot, not EPEL):
BuildRequires:	perl-devel perl(base.pm) perl(strict.pm) perl(warnings.pm) perl(Time/HiRes.pm)
Source44: import.info

%description
BibTeX provides an easy to use means to integrate citations and
bibliographies into LaTeX documents. But the user is left alone with
the management of the BibTeX files. The program BibTool is intended to
fill this gap. BibTool allows the manipulation of BibTeX files which
goes beyond the possibilities --- and intentions --- of BibTeX.

%prep
%setup -q -n %{name}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

sed -i -e 's%^#!/usr/local/bin/tclsh%#! %{_bindir}/tclsh%' Tcl/bibtool.tcl
sed -i -e 's%^#!/usr/local/bin/perl%#! %{_bindir}/perl%' Perl/bibtool.pl
# configure will recreate the directory, but only with config.h within
rm -rf regex-0.12

%build
%configure --libdir=%{_datadir}
sed -i -e 's#@kpathsea_lib_static@##' makefile
%make_build CFLAGS="$RPM_OPT_FLAGS"
make doc

%check
make check

%install
make install INSTALLPREFIX=$RPM_BUILD_ROOT INSTALL='install -p -m 755'
make install-man INSTALLPREFIX=$RPM_BUILD_ROOT INSTALL='install -p -m 644'

%files
%doc --no-dereference COPYING
%doc Changes.tex README.md THANKS
%doc doc/bibtool.pdf doc/ref_card.pdf
%doc Perl/ Tcl/
%{_bindir}/bibtool
%{_datadir}/BibTool/
%{_mandir}/man1/bibtool.1*

%changelog
