Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate libglvnd-devel python3-devel rpm-build-python3 unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global version_major 2021
%global version_minor 06
%global version_patch 23

Name:           EmptyEpsilon
Summary:        Spaceship bridge simulator game
Version:        %{version_major}.%{version_minor}.%{version_patch}
Release:        alt1_4
License:        GPLv2

BuildRequires:  ccmake cmake ctest
BuildRequires:  gcc-c++
BuildRequires:  libSFML-devel >= 2.5.1
BuildRequires:  libGLU-devel >= 9.0.0
BuildRequires:  desktop-file-utils
# The following version of "glm-devel" is not currently available for Fedora 33 and older
BuildRequires:  libglm-devel >= 0.9.9.8
BuildRequires:  libjson11-devel

ExcludeArch:    ppc64 ppc64le

URL:            http://emptyepsilon.org/
Source0:        https://github.com/daid/EmptyEpsilon/archive/EE-%{version}.zip#/EmptyEpsilon-EE-%{version}.zip
Source1:        https://github.com/daid/SeriousProton/archive/EE-%{version}.zip#/SeriousProton-EE-%{version}.zip



# EmptyEpsilon downstream patches:
#Patch1:

# SeriousProton downstream patches:
#Patch20:

# EmptyEpsilon upstream patches:
Patch40:        upstream_EE_001_69d93e6acd.patch
Patch41:        upstream_EE_002_872ef2667c.patch
Patch42:        upstream_EE_003_ee0cd42bfe.patch
Patch43:        upstream_EE_004_530fe32f95.patch

# SeriousProton upstream patches:
Patch60:        upstream_SP_001_32509f2db9.patch
Patch61:        upstream_SP_002_d52a1b1b61.patch
Patch62:        upstream_SP_003_ec30d87c22.patch
Patch63:        upstream_SP_004_adbba45fd9.patch
Patch64:        upstream_SP_005_0d1ac45b73.patch


Requires:     xclip
Source44: import.info

%description
EmptyEpsilon places you in the roles of a spaceship's bridge officers, like
those seen in Star Trek. While you can play EmptyEpsilon alone or with friends,
the best experience involves 6 players working together on each ship.

Each officer fills a unique role: Captain, Helms, Weapons, Relay, Science, and
Engineering. Except for the Captain, each officer operates part of the ship
through a specialized screen. The Captain relies on their trusty crew to report
information and follow orders.

Note: Network play require port 35666 UDP and TCP allowed in firewall.

%prep
%setup -q -a 1 -n EmptyEpsilon-EE-%{version}

%patch40 -p1
%patch41 -p1
%patch42 -p1
%patch43 -p1
%patch60 -p1 -d SeriousProton-EE-%{version}
%patch61 -p1 -d SeriousProton-EE-%{version}
%patch62 -p1 -d SeriousProton-EE-%{version}
%patch63 -p1 -d SeriousProton-EE-%{version}
%patch64 -p1 -d SeriousProton-EE-%{version}


%build
%{fedora_v2_cmake3} \
  -DSERIOUS_PROTON_DIR=SeriousProton-EE-%{version}/ \
  -DCPACK_PACKAGE_VERSION_MAJOR=%{version_major} \
  -DCPACK_PACKAGE_VERSION_MINOR=%{version_minor} \
  -DCPACK_PACKAGE_VERSION_PATCH=%{version_patch} \
  -DWITH_JSON="system" \
  -DWITH_GLM="system" \
  -DCONFIG_DIR=%{_sysconfdir}/emptyepsilon/



%fedora_v2_cmake3_build

%install
%fedora_v2_cmake3_install

# icon to pixmaps
mkdir -p %{buildroot}%{_datadir}/pixmaps
install -p -m 644 ./logo.png %{buildroot}%{_datadir}/pixmaps/EmptyEpsilon.png

# .desktop file
mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop <<'EOF'
[Desktop Entry]
Name=%{name}
GenericName=EmptyEpsilon
Comment=Spaceship bridge simulator game
Exec=EmptyEpsilon
Icon=EmptyEpsilon
Terminal=false
Type=Application
Categories=Game;Simulation;
EOF
desktop-file-validate %{buildroot}%{_datadir}/applications/%{name}.desktop

%files
%doc README.md */script_reference.html
%doc --no-dereference LICENSE
%{_bindir}/EmptyEpsilon
%{_datadir}/emptyepsilon
%{_datadir}/pixmaps/EmptyEpsilon.png
%{_datadir}/applications/%{name}.desktop

%changelog
