Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           NetPIPE
Version:        3.7.2
Release:        alt1_7
Summary:        Network Protocol Independent Performance Evaluator
License:        GPL+
URL:            http://bitspjoule.org/netpipe/
Source0:        http://bitspjoule.org/netpipe/code/NetPIPE-%{version}.tar.gz

BuildRequires:  gcc
Source44: import.info
%description
NetPIPE is a protocol independent performance tool that visually represents
the network performance under a variety of conditions. It performs simple
ping-pong tests, bouncing messages of increasing size between two processes,
whether across a network or within an SMP system. Message sizes are chosen
at regular intervals, and with slight perturbations, to provide a complete
test of the communication system. Each data point involves many ping-pong
tests to provide an accurate timing. Latencies are calculated by dividing
the round trip time in half for small messages ( < 64 Bytes ).

%prep
%setup -q
# Harden building.
sed -i 's|-I$(SRC)|-I$(SRC) $(LDFLAGS)|g' makefile

%build
%make_build memcpy tcp tcp6 CFLAGS="%{optflags}" LDFLAGS="%{?__global_ldflags}"

%install
chmod 0644 dox/*
chmod 0644 bin/feplot
chmod 0644 bin/geplot
chmod 0644 bin/nplaunch

install -Dpm0755 NPmemcpy %{buildroot}%{_bindir}/NPmemcpy
install -Dpm0755 NPtcp %{buildroot}%{_bindir}/NPtcp
install -Dpm0755 NPtcp6 %{buildroot}%{_bindir}/NPtcp6
install -Dpm0644 dox/netpipe.1 %{buildroot}%{_mandir}/man1/netpipe.1

%files
%doc dox/netpipe_paper.ps dox/README dox/np_cluster2002.pdf dox/np_euro.pdf
%doc bin/feplot bin/geplot bin/nplaunch
%{_bindir}/*
%{_mandir}/man1/netpipe.1*

%changelog
