Group: Sciences/Mathematics
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname R6
%global packver 2.6.1

%global __suggests_exclude ^R\\((pryr)\\)

Name:             R-%{packname}
Version:          %{packver}
Release:          alt1_4
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packver}.tar.gz
License:          MIT
URL:              http://cran.r-project.org/web/packages/R6/index.html
Summary:          Classes with Reference Semantics
BuildRequires:    R-devel >= 3.0.0, tex(latex)
# For tests
# BuildRequires:  R-testthat
# Not in fedora yet
# BuildRequires:  R-pryr
# These are in, but with tests disabled, no reason to pull them into the BuildRoot
# BuildRequires:  R-knitr
# BuildRequires:  R-microbenchmark
# BuildRequires:  R-ggplot2
# BuildRequires:  R-scales
BuildArch:        noarch
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
The R6 package allows the creation of classes with reference semantics,
similar to R's built-in reference classes. Compared to reference classes,
R6 classes are simpler and lighter-weight, and they are not built on S4
classes so they do not require the methods package. These classes allow
public and private members, and they support inheritance, even when the
classes are defined in different packages.

%prep
%setup -q -c -n %{packname}

%build

%install
mkdir -p $RPM_BUILD_ROOT%{_datadir}/R/library
%{_bindir}/R CMD INSTALL -l $RPM_BUILD_ROOT%{_datadir}/R/library %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -rf $RPM_BUILD_ROOT%{_datadir}/R/library/R.css

%check
# Can't run this yet, needs lots of deps
%if 0
%{_bindir}/R CMD check %%{packname}
%endif

%files
%dir %{_datadir}/R/library/%{packname}
%doc %{_datadir}/R/library/%{packname}/LICENSE
%doc %{_datadir}/R/library/%{packname}/html
%doc %{_datadir}/R/library/%{packname}/NEWS.md
%{_datadir}/R/library/%{packname}/DESCRIPTION
%{_datadir}/R/library/%{packname}/INDEX
%{_datadir}/R/library/%{packname}/NAMESPACE
%{_datadir}/R/library/%{packname}/Meta
%{_datadir}/R/library/%{packname}/R
%{_datadir}/R/library/%{packname}/help

%changelog
