Group: Sciences/Mathematics
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname  RCurl
%global packver   1.98
%global packrel   1.8

Name:             R-%{packname}
Version:          %{packver}.%{packrel}
Release:          alt1_13
Summary:          General network (HTTP/FTP) client interface for R
# Automatically converted from old format: BSD - review is highly recommended.
License:          LicenseRef-Callaway-BSD
URL:              http://cran.r-project.org/web/packages/RCurl/index.html
Source0:          http://cran.r-project.org/src/contrib/%{packname}_%{packver}-%{packrel}.tar.gz
Requires:         texlive texlive-collection-basic
BuildRequires:    R-devel >= 3.4.0, R-bitops R-base R-tcltk, libcurl-devel
Source44: import.info
ExcludeArch: %R_exclude_arches
# This is a suggests
# BuildRequires:    R-XML

%description
The package allows one to compose general HTTP requests and provides convenient 
functions to fetch URIs, get & post forms, etc. and process the results 
returned by the Web server. This provides a great deal of control over the 
HTTP/FTP/... connection and the form of the request while providing a 
higher-level interface than is available just using R socket connections. 
Additionally, the underlying implementation is robust and extensive, supporting 
FTP/FTPS/TFTP (uploads and downloads), SSL/HTTPS, telnet, dict, ldap, and also 
supports cookies, redirects, authentication, etc.

%prep
%setup -c -q -n %{packname}
chmod -x RCurl/src/curl_base64.c

%build

%install
mkdir -p %{buildroot}%{_libdir}/R/library
%{_bindir}/R CMD INSTALL %{packname} -l %{buildroot}%{_libdir}/R/library 
# Clean up in advance of check
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -rf %{buildroot}%{_libdir}/R/library/R.css

%files
%dir %{_libdir}/R/library/%{packname}
%doc %{_libdir}/R/library/%{packname}/html
%doc %{_libdir}/R/library/%{packname}/DESCRIPTION
%doc %{_libdir}/R/library/%{packname}/doc/
%{_libdir}/R/library/%{packname}/LICENSE
%{_libdir}/R/library/%{packname}/INDEX
%{_libdir}/R/library/%{packname}/NAMESPACE
%{_libdir}/R/library/%{packname}/Meta
%{_libdir}/R/library/%{packname}/R
%{_libdir}/R/library/%{packname}/help
%{_libdir}/R/library/%{packname}/libs/
%{_libdir}/R/library/%{packname}/CurlSSL/
%{_libdir}/R/library/%{packname}/HTTPErrors/
%{_libdir}/R/library/%{packname}/data/
%{_libdir}/R/library/%{packname}/enums/
%{_libdir}/R/library/%{packname}/etc/
%{_libdir}/R/library/%{packname}/examples/

%changelog
