Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: gcc-c++ tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname  Rsolid

Name:		  R-%{packname}
Version:	  0.9.31
Release:	  alt3_54
Summary:	  Quantile normalization and base calling for second generation sequencing data

License:	  Artistic-2.0
URL:		  http://rafalab.jhsph.edu/Rsolid/
Source0:	  http://rafalab.jhsph.edu/Rsolid/Rsolid_0.9-31.tar.gz
Patch0:           R-Rsolid-R3.patch
Patch1:           R-Rsolid-configure-c99.patch
BuildRequires:	  R-devel >= 3.4.0 tex(latex) hdf5-tools libhdf5-devel 
Source44: import.info
ExcludeArch: %R_exclude_arches

%package	  devel
Group: Other
Summary:	  Development files for %{name}
Requires:	  %{name} = %{version}-%{release}

%description

Rsolid is an R package for normalizing fluorescent intensity data from
ABI/SOLiD second generation sequencing platform. It has been observed
that the color-calls provided by factory software contain technical
artifacts, where the proportions of colors called are extremely
variable across sequencing cycles. Under the random DNA fragmentation
assumption, these proportions should be equal across sequencing cycles
and proportional to the dinucleotide frequencies of the sample.

Rsolid implements a version of the quantile normalization algorithm
that transforms the intensity values before calling colors. Results
show that after normalization, the total number of mappable reads
increases by around 5%, and number of perfectly mapped reads increases
by 10%. Moreover a 2-5% reduction in overall error rates is observed,
with a 2-6% reduction in the rate of valid adjacent color
mis-matches. The latter is important, since it leads to a decrease in
false-positive SNP calls.

The normalization algorithm is computationally efficient. In a test we
are able to process 300 million reads in 2 hours using 10 computer
cluster nodes. The engine functions of the package are written in C
for better performance.

%description	devel

The %{name}-devel  package contains header and library files for
developing applications that use %{name}

%prep
%setup -q -c -n %{packname}
%patch0  -p1 -b .fixed
%patch1  -p1 -b .configure-c99

%build

%install
# x86/x86_64 -> Architecture dependent package
mkdir -p %{buildroot}%{_libdir}/R/library 
R CMD INSTALL %{packname} --configure-args="--with-hdf5=%{_prefix}" -l %{buildroot}%{_libdir}/R/library
# Clean up in advance of check
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -rf %{buildroot}%{_libdir}/R/library/R.css

#Remove executable files to pass check
rm -rf %{packname}/src/hdf5-1.8.3
rm -rf %{packname}/config.status
rm -rf %{packname}/configure

%check
%{_bindir}/R CMD check %{packname}

%files
%dir %{_libdir}/R/library/%{packname}
%doc %{_libdir}/R/library/%{packname}/DESCRIPTION
%doc %{_libdir}/R/library/%{packname}/html
%{_libdir}/R/library/%{packname}/INDEX
%{_libdir}/R/library/%{packname}/Meta
%{_libdir}/R/library/%{packname}/NAMESPACE
%{_libdir}/R/library/%{packname}/R
%{_libdir}/R/library/%{packname}/data
%{_libdir}/R/library/%{packname}/help
%{_libdir}/R/library/%{packname}/libs

%files	devel
%{_libdir}/R/library/%{packname}/include


%changelog
