# BEGIN SourceDeps(oneline):
BuildRequires: tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname  argon2
%global rlibdir  %{_libdir}/R/library


Name:             R-%{packname}
Version:          0.2.0
Release:          alt2_14
Summary:          Secure Password Hashing

License:          BSD
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_0.2-0.tar.gz
Patch0001:        0001-Build-against-system-libraries.patch

# Here's the R view of the dependencies world:
# Depends:
# Imports:
# Suggests:
# LinkingTo:
# Enhances:

BuildRequires:    R-devel tex(latex)
BuildRequires:    libargon2-devel >= 20161029
BuildRequires:    libb2-devel
Source44: import.info

%description
Utilities for secure password hashing via the argon2 algorithm. It is a
relatively new hashing algorithm and is believed to be very secure. The
'argon2' implementation included in the package is the reference
implementation.  The package also includes some utilities that should be
useful for digest authentication, including a wrapper of 'blake2b'.  For
similar R packages, see sodium and 'bcrypt'.  See
<https://en.wikipedia.org/wiki/Argon2> or
<https://eprint.iacr.org/2015/430.pdf> for more information.


%prep
%setup -q -c -n %{packname}

# Delete bundled libraries.
pushd %{packname}
rm -r src/argon2
%patch0001 -p1
popd


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css


%check
%{_bindir}/R CMD check %{packname}


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/html
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/CITATION
%{rlibdir}/%{packname}/COPYRIGHTS
%{rlibdir}/%{packname}/LICENSE
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help
%dir %{rlibdir}/%{packname}/libs
%{rlibdir}/%{packname}/libs/%{packname}.so


%changelog
