Group: Sciences/Mathematics
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: /usr/bin/xvfb-run
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with check

%global packname clipr
%global packver  0.8.0
%global rlibdir  %{_datadir}/R/library

Name:             R-%{packname}
Version:          0.8.0
Release:          alt1_14
Summary:          Read and Write from the System Clipboard

# Automatically converted from old format: GPLv3 - review is highly recommended.
License:          GPL-3.0-only
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packver}.tar.gz

# Here's the R view of the dependencies world:
# Depends:
# Imports:   R-utils
# Suggests:  R-covr, R-knitr, R-rmarkdown, R-rstudioapi >= 0.5, R-testthat >= 2.0.0
# LinkingTo:
# Enhances:

BuildArch:        noarch
Requires:         xsel
BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    R-base R-tcltk
%if %{with check}
BuildRequires:    R-knitr
BuildRequires:    R-rmarkdown
BuildRequires:    R-rstudioapi >= 0.5
BuildRequires:    R-testthat >= 2.0.0
BuildRequires:    xsel
BuildRequires:    xorg-xvfb xvfb-run
%endif
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
Simple utility functions to read from and write to the Windows, OS X, and
X11 clipboards.


%prep
%setup -q -c -n %{packname}

# Don't need coverage; it's not packaged either.
sed -i 's/covr, //g' %{packname}/DESCRIPTION


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css


%check
%if %{with check}
TRAVIS=true TRAVIS_CLIP=xsel CLIPR_ALLOW=TRUE \
    xvfb-run \
        %{_bindir}/R CMD check %{packname}
%endif


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/doc
%doc %{rlibdir}/%{packname}/html
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/NEWS.md
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help
%{rlibdir}/%{packname}/rstudio


%changelog
