Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname gtools
%global packver  3.9.3
%global rlibdir  %{_libdir}/R/library

# Some tests use the network.
%bcond_with network

%bcond_with suggests

Name:             R-%{packname}
Version:          %{packver}
Release:          alt1_13
Summary:          Various R Programming Tools

# Automatically converted from old format: GPLv2 - review is highly recommended.
License:          GPL-2.0-only
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packver}.tar.gz

# Here's the R view of the dependencies world:
# Depends:   R-methods, R-stats, R-utils
# Imports:
# Suggests:  R-car, R-gplots, R-knitr, R-rstudioapi, R-SGP, R-taxize
# LinkingTo:
# Enhances:

BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
%if %{with suggests}
BuildRequires:    R-car
BuildRequires:    R-gplots
BuildRequires:    R-knitr
BuildRequires:    R-rstudioapi
BuildRequires:    R-SGP
BuildRequires:    R-taxize
%endif
Source44: import.info
ExcludeArch: %R_exclude_arches


%description
Functions to assist in R programming, including:
    - assist in developing, updating, and maintaining R and R packages,
    - calculate the logit and inverse logit transformations,
    - test if a value is missing, empty or contains only NA and NULL values,
    - manipulate R's .Last function,
    - define macros,
    - detect odd and even integers,
    - convert strings containing non-ASCII characters (like single quotes) to
      plain ASCII,
    - perform a binary search,
    - sort strings containing both numeric and character components,
    - create a factor variable from the quantiles of a continuous variable,
    - enumerate permutations and combinations,
    - calculate and convert between fold-change and log-ratio,
    - calculate probabilities and generate random numbers from Dirichlet
      distributions,
    - apply a function over adjacent subsets of a vector,
    - modify the TCP_NODELAY flag for socket objects,
    - efficient 'rbind' of data frames, even if the column names don't match,
    - generate significance stars from p-values,
    - convert characters to/from ASCII codes,
    - convert character vector to ASCII representation.


%prep
%setup -q -c -n %{packname}


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css


%check
%if %{with network}
 %if %{with suggests}
  %{_bindir}/R CMD check %{packname}
 %else
  _R_CHECK_FORCE_SUGGESTS_=0 %{_bindir}/R CMD check %{packname}
 %endif
%else
 # No network for examples that check R version.
 rm %{packname}/tests/test_setTCPNoDelay.R
 %if %{with suggests}
  %{_bindir}/R CMD check %{packname} --no-examples
 %else
  _R_CHECK_FORCE_SUGGESTS_=0 %{_bindir}/R CMD check %{packname} --no-examples
 %endif
%endif


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/html
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/NEWS.md
%doc %{rlibdir}/%{packname}/ChangeLog
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/WORDLIST
%{rlibdir}/%{packname}/help
%{rlibdir}/%{packname}/data
%dir %{rlibdir}/%{packname}/libs
%{rlibdir}/%{packname}/libs/%{packname}.so


%changelog
