Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: /usr/bin/plink tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname  pbdRPC
%global packvers  0.2-1
%global rlibdir  %{_datadir}/R/library

Name:             R-%{packname}
Version:          0.2.1
Release:          alt2_27
Summary:          Programming with Big Data -- Remote Procedure Call

# NOTE: There is a bundled copy of putty which is MIT, but we disable its usage
# in favor of ssh.
License:          MPL-2.0
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packvers}.tar.gz
# https://github.com/snoweye/pbdRPC/pull/7
Patch0001:        fix-configure.patch

# Here's the R view of the dependencies world:
# Depends:   R-tools
# Imports:
# Suggests:
# LinkingTo:
# Enhances:

BuildArch:        noarch
Requires:         openssh-clients
BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    R-base R-tcltk
BuildRequires:    openssh-clients
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
A very light implementation yet secure for remote procedure calls with
unified interface via ssh (OpenSSH).


%prep
%setup -q -c -n %{packname}

pushd %{packname}
%patch0001  -p1

# Remove all arch-requiring bits, as they are unnecessary.
sed -i '/NeedsCompilation/s/yes/no/' DESCRIPTION
rm -r configure* src
sed -i '/src/d' MD5
popd


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css
# Remove unused license (it's installed even if option is disabled.)
rm %{buildroot}%{rlibdir}/%{packname}/putty_LICENCE


%check
%{_bindir}/R CMD check %{packname}


%files
%doc --no-dereference %{packname}/COPYING
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/doc
%doc %{rlibdir}/%{packname}/html
%doc %{rlibdir}/%{packname}/CITATION
%{rlibdir}/%{packname}/DESCRIPTION
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help


%changelog
