# BEGIN SourceDeps(oneline):
BuildRequires: tex(dehypht.tex)
# END SourceDeps(oneline)
Group: Sciences/Mathematics
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Tests requires processx which requires this package.
%bcond_without bootstrap

%global packname ps
%global packver  1.6.0
%global rlibdir  %{_libdir}/R/library

Name:             R-%{packname}
Version:          1.6.0
Release:          alt1_4
Summary:          List, Query, Manipulate System Processes

License:          MIT
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packver}.tar.gz
# No network on builders.
Patch0001:        0001-Don-t-run-example-that-uses-the-network.patch

# Here's the R view of the dependencies world:
# Depends:
# Imports:   R-utils
# Suggests:  R-callr, R-covr, R-curl, R-pingr, R-processx >= 3.1.0, R-R6, R-rlang, R-testthat, R-tibble
# LinkingTo:
# Enhances:

BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    R-base R-tcltk
%if %{without bootstrap}
BuildRequires:    R-callr
BuildRequires:    R-curl
BuildRequires:    R-pingr
BuildRequires:    R-processx >= 3.1.0
BuildRequires:    R-R6
BuildRequires:    R-rlang
BuildRequires:    R-testthat
BuildRequires:    R-tibble
%endif
Source44: import.info

%description
List, query and manipulate all system processes, on 'Windows', 'Linux' and
'macOS'.


%prep
%setup -q -c -n %{packname}

pushd %{packname}
%patch0001 -p1

# Don't need coverage; it's not packaged either.
sed -i 's/covr, //g' DESCRIPTION
popd


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css

# Only used to run ./configure on Windows.
rm %{buildroot}%{rlibdir}/%{packname}/tools/winver.R


%check
%if %{without bootstrap}
%{_bindir}/R CMD check %{packname}
%else
_R_CHECK_FORCE_SUGGESTS_=0 %{_bindir}/R CMD check %{packname} --no-examples --no-tests
%endif


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/html
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/NEWS.md
%{rlibdir}/%{packname}/LICENSE
%doc %{rlibdir}/%{packname}/internals.md
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help
%{rlibdir}/%{packname}/bin
%dir %{rlibdir}/%{packname}/libs
%{rlibdir}/%{packname}/libs/%{packname}.so
%{rlibdir}/%{packname}/tools
%{rlibdir}/%{packname}/WORDLIST


%changelog
