# BEGIN SourceDeps(oneline):
BuildRequires: tex(dehypht.tex)
# END SourceDeps(oneline)
Group: Engineering
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname qcc

Name:             R-%{packname}
Version:          2.2
Release:          alt1_19
Source0:          http://cran.r-project.org/src/contrib/qcc_%{version}.tar.gz
License:          GPLv2+
URL:              http://cran.r-project.org/web/packages/qcc/index.html
Summary:          SQC package for R
BuildRequires:    R-devel >= 3.0.0, tex(latex)
BuildArch:        noarch
Source44: import.info

%description
An R package for quality control charting and statistical process control.

The qcc package for the R statistical environment provides:
- Plot Shewhart quality control charts
- Plot Cusum and EMWA charts for continuous data
- Draw operating characteristic curves
- Perform process capability analysis
- Draw Pareto charts and cause-and-effect diagrams

%prep
%setup -q -c -n %{packname}
#Fix permissions
find -type f | xargs chmod -x
#Fix line ending
mv qcc/inst/CITATION qcc/inst/CITE
tr -d '\r' <qcc/inst/CITE >qcc/inst/CITATION
rm -f qcc/inst/CITE

%build

%install
mkdir -p $RPM_BUILD_ROOT%{_datadir}/R/library
%{_bindir}/R CMD INSTALL -l $RPM_BUILD_ROOT%{_datadir}/R/library %{packname}
# Clean up in advance of check
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -rf $RPM_BUILD_ROOT%{_datadir}/R/library/R.css

%check
%{_bindir}/R CMD check %{packname}

%files
%dir %{_datadir}/R/library/%{packname}
%doc %{_datadir}/R/library/%{packname}/html
%doc %{_datadir}/R/library/%{packname}/CITATION
%doc %{_datadir}/R/library/%{packname}/DESCRIPTION 
%doc %{_datadir}/R/library/%{packname}/LICENCE
%{_datadir}/R/library/%{packname}/doc
%{_datadir}/R/library/%{packname}/demo
%{_datadir}/R/library/%{packname}/INDEX
%{_datadir}/R/library/%{packname}/NAMESPACE
%{_datadir}/R/library/%{packname}/Meta
%{_datadir}/R/library/%{packname}/R
%{_datadir}/R/library/%{packname}/data
%{_datadir}/R/library/%{packname}/help

%changelog
