Group: Sciences/Mathematics
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# When we are bootstrapping, we drop some dependencies, and/or build time tests.
%bcond_without bootstrap

%global packname rlang
%global packver  0.4.11
%global rlibdir  %{_libdir}/R/library

Name:             R-%{packname}
Version:          0.4.11
Release:          alt1_3
Summary:          Functions for Base Types and Core R and 'Tidyverse' Features

License:          MIT
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packver}.tar.gz
Patch0001:        0001-Unbundle-libxxhash.patch
# https://github.com/r-lib/rlang/pull/1084
Patch0002:        0002-Add-test-hashes-for-big-endian-machines.patch

# Here's the R view of the dependencies world:
# Depends:
# Imports:   R-utils
# Suggests:  R-cli, R-covr, R-crayon, R-glue, R-magrittr, R-methods, R-pak, R-pillar, R-rmarkdown, R-testthat >= 3.0.0, R-vctrs >= 0.2.3, R-withr
# LinkingTo:
# Enhances:

BuildRequires:    pkgconfig(libxxhash)
BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    R-base R-tcltk
%if %{without bootstrap}
BuildRequires:    R-cli
BuildRequires:    R-crayon
BuildRequires:    R-glue
BuildRequires:    R-magrittr
BuildRequires:    R-base R-tcltk
BuildRequires:    R-pak
BuildRequires:    R-pillar
BuildRequires:    R-rmarkdown
BuildRequires:    R-testthat >= 3.0.0
BuildRequires:    R-vctrs >= 0.2.3
BuildRequires:    R-withr
%endif
Source44: import.info

%description
A toolbox for working with base types, core R features like the condition
system, and core 'Tidyverse' features like tidy evaluation.


%prep
%setup -q -c -n %{packname}

pushd %{packname}
%patch0001 -p1
# Upstream now skips these tests if big endian
# %%patch0002 -p1

# Don't need coverage; it's not packaged either.
sed -i 's/covr, //g' DESCRIPTION
popd


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css


%check
export LANG=C.UTF-8
%if %{without bootstrap}
%{_bindir}/R CMD check %{packname}
%endif


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/html
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/NEWS.md
%{rlibdir}/%{packname}/LICENSE
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help
%dir %{rlibdir}/%{packname}/libs
%{rlibdir}/%{packname}/libs/%{packname}.so
%{rlibdir}/%{packname}/backtrace-ver


%changelog
