Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           abbayedesmorts-gpl
Version:        2.0.5
Release:        alt1_2
Summary:        Platform game set in 13th century

# Graphics and Sounds are licensed under
# Creative Commons 3.0 Attribution license.
License:        GPL-3.0-only AND CC-BY-3.0
# Original Windows game by locomalito
# https://locomalito.com/abbaye_des_morts.php
URL:            https://github.com/nevat/abbayedesmorts-gpl
Source0:        https://github.com/nevat/abbayedesmorts-gpl/archive/v%{version}.tar.gz#/%{name}-%{version}.tar.gz

BuildRequires:  gcc
BuildRequires:  libSDL2-devel libSDL2-devel-static
BuildRequires:  libSDL2_mixer-devel
BuildRequires:  libSDL2_image-devel
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  desktop-file-utils
Requires:       icon-theme-hicolor
Source44: import.info

%description
In the 13th century, the Cathars, who preach about good Christian beliefs, 
were being expelled by the Catholic Church out of the Languedoc region in 
France.

One of them, called Jean Raymond, found an old church in which to hide, not 
knowing that beneath its ruins lay buried an ancient evil.

A style close to Spectrum ZX, with its dark background and bright colors, 
proper fit with the story, because it does look old and somewhat horrifying. 
Also, the gameplay is directly inspired by Manic Miner and Jet Set Willy.


%prep
%setup -q


# Enable verbose build
sed -i 's/@$(CC)/$(CC)/' Makefile


%build

%make_build


%install
%makeinstall_std

# Install icons
rm %{buildroot}%{_datadir}/pixmaps/abbaye.png
cp -a abbaye.png abbaye48.png
for px in 48 64 128; do
  install -d %{buildroot}%{_datadir}/icons/hicolor/${px}x${px}/apps
  install -p -m 644 abbaye${px}.png \
    %{buildroot}%{_datadir}/icons/hicolor/${px}x${px}/apps/abbaye.png
done

# Validate desktop file
desktop-file-validate %{buildroot}%{_datadir}/applications/abbaye.desktop

# Validate AppData file
appstream-util validate-relax --nonet %{buildroot}%{_datadir}/appdata/abbaye.appdata.xml


%files
%{_bindir}/abbayev2
%{_datadir}/abbayev2
%{_datadir}/appdata/abbaye.appdata.xml
%{_datadir}/applications/abbaye.desktop
%{_datadir}/icons/hicolor/*/apps/abbaye.png
%doc ReadMe.md ChangeLog.md screenshots
%doc --no-dereference COPYING


%changelog
