# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: /usr/bin/desktop-file-install gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           acoustid-fingerprinter
Version:        0.6
Release:        alt1_16
Summary:        Music AcoustID fingerprinting application

Group:          Sound
License:        GPLv2+
URL:            http://acoustid.org/fingerprinter
Source:         https://github.com/downloads/lalinsky/%{name}/%{name}-%{version}.tar.gz
Patch0:         acoustid-fingerprinter-fix-cmake-for-taglib-1.10.patch
Patch1:         acoustid-fingerprinter-ffmpeg3.patch
Patch2:         acoustid-fingerprinter-0.6-ffmpeg-2.0.patch
# fix decoding with current ffmpeg
# https://bugs.mageia.org/show_bug.cgi?id=9706
Patch3:         acoustid-fingerprinter-request-s16-audio-format.patch
# from debian: fix build with gcc 7
Patch4:         acoustid-fingerprinter-gcc6.patch

BuildRequires:  ccmake cmake ctest
BuildRequires:  libqt4-devel qt5-declarative-devel qt5-tools
BuildRequires:  libavcodec-devel libavdevice-devel libavfilter-devel libavformat-devel libavresample-devel libavutil-devel libpostproc-devel libswresample-devel libswscale-devel
BuildRequires:  pkgconfig(taglib)
BuildRequires:  desktop-file-utils
BuildRequires:  pkgconfig(libchromaprint)
Source44: import.info


%description
Acoustid fingerprinter is a cross-platform GUI application that uses
Chromaprint to submit audio fingerprints from your music collection
to the Acoustid database. Only tagged audio files are submitted.
Files tagged by MusicBrainz applications such as Picard are preferred,
but it will submit fingerprints for any files that have tags such as
track title, artist name, album name, etc.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1


%build
%{mageia_cmake}
%mageia_cmake_build

%install
%mageia_cmake_install

install -d -m755 %{buildroot}%{_datadir}/applications

desktop-file-install \
  --remove-key Encoding \
  --dir %{buildroot}%{_datadir}/applications \
  %{buildroot}%{_datadir}/applications/%{name}.desktop

install -p -D -m 0644 images/%{name}.svg  %{buildroot}%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg

%files
%doc CHANGES.txt COPYING.txt 
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg


%changelog
