# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name acr38u
%define usbdropdir %(pkg-config libpcsclite --variable="usbdropdir" 2>/dev/null)
%define major   0
%define libname lib%{name}%{major}
%define develname lib%{name}-devel
%define build_version 100711

Summary:        ACS ACR 38 USB (acr38u) Smartcard Reader driver for PCSC-lite
Name:           acr38u
Version:        1.7.11
Release:        alt1_11
License:        GPL
Group:          System/Kernel and hardware
URL:            https://www.acs.com.hk/en/driver/200/acr38u-h1-smart-card-reader/
# From the Gentoo ebuild:
# <<<
# tarball release is encapsuled in a .zip file :-(
# http://www.acs.com.hk/drivers/eng/ACR38_Driver_Lnx_101_P.zip
# I'm waiting an answer from info@acs.com.hk about that !
# SRC_URI="https://www.linuxunderground.be/${MY_P}.tar.bz2"
# HOMEPAGE="http://www.acs.com.hk"
# >>>
# Source0:      http://www.acs.com.hk/download/ACR38_LINUX_%{build_version}_P.tar.gz
Source0:        https://www.linuxunderground.be/ACR38_LINUX_%{build_version}_P.tar.bz2
Patch0:         acr38u-linkage_fix.diff
BuildRequires:  pkgconfig(libpcsclite) >= 1.3.1
BuildRequires:  pkgconfig(libusb) >= 0.1.12
Requires(post): pcsc-lite
Requires(postun): pcsc-lite
Requires:       pcsc-lite
Requires:       %{libname} = %{version}-%{release}
Source44: import.info

%description
CCID ACR38u Smart Card reader driver for PCSC-lite.

%package -n     %{libname}
Group:          System/Libraries
Summary:        Shared library for %{name}

%description -n %{libname}
Shared library for the CCID ACR38u Smart Card reader driver for
PCSC-lite.

%package -n     %{develname}
Summary:        Development library for %{name}
Group:          Development/C
Requires:       %{libname} = %{version}
Provides:       %{name}-devel = %{version}-%{release}

%description -n %{develname}
Development files for the CCID ACR38u Smart Card reader driver for
PCSC-lite.

%prep
%setup -q -n ACR38_LINUX_%{build_version}_P
%patch0


%build
rm -rf autom4te.cache
autoreconf -fis

%configure \
        --disable-dependency-tracking \
        --disable-static \
        --enable-usbdropdir="%{buildroot}%{usbdropdir}"
%make_build

%install
%makeinstall_std
rm -f %{buildroot}%{_libdir}/*.la

# Move the .pc file to the correct place on x86-64 and aarch64
# Test should probably compare _libdir with _prefix/lib rather than listing arches
%ifarch x86_64 aarch64
mkdir -p %{buildroot}%{_libdir}/pkgconfig
mv %{buildroot}%{_prefix}/lib/pkgconfig/libacr38ucontrol.pc %{buildroot}%{_libdir}/pkgconfig/libacr38ucontrol.pc
%endif

%post
/sbin/service pcscd condrestart > /dev/null 2>/dev/null || :

%postun
/sbin/service pcscd condrestart > /dev/null 2>/dev/null || :

%files
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README* doc/README*
%{usbdropdir}/*

%files -n %{libname}
%{_libdir}/*.so.*

%files -n %{develname}
%{_libdir}/*.so
%{_includedir}/*
%{_libdir}/pkgconfig/*.pc


%changelog
