Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires: libexpat-devel zip
# END SourceDeps(oneline)
BuildRequires: chrpath
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           activemq-cpp
Version:        3.9.5
Release:        alt1_4
Summary:        C++ implementation of JMS-like messaging client

License:        Apache-2.0
URL:            http://activemq.apache.org/cms/
Source0:        http://www.apache.org/dist/activemq/activemq-cpp/%{version}/activemq-cpp-library-%{version}-src.tar.gz
Patch:          activemq-cpp-3.8.2-system-zlib.patch

BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  libssl-devel
BuildRequires:  zlib-devel
BuildRequires:  libaprutil1-devel >= 1.3
BuildRequires:  cppunit-devel >= 1.10.2
BuildRequires:  libuuid-devel
Source44: import.info

%description
activemq-cpp is a JMS-like API for C++ for interfacing with Message
Brokers such as Apache ActiveMQ.  C++ messaging service helps to make your
C++ client code much neater and easier to follow. To get a better feel for
CMS try the API Reference.
ActiveMQ-CPP is a client only library, a message broker such as Apache
ActiveMQ is still needed for your clients to communicate.

%package devel
Group: Development/Other
Summary:        C++ implementation header files for JMS-like messaging
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig

%description devel
activemq-cpp is a JMS-like API for C++ for interfacing with Message
Brokers such as Apache ActiveMQ.  C++ messaging service helps to make
your C++ client code much neater and easier to follow. To get a better
feel for CMS try the API Reference.  ActiveMQ-CPP is a client only
library, a message broker such as Apache ActiveMQ is still needed
for your clients to communicate.

%{name}-devel contains development header files.


%prep
%setup -q -n activemq-cpp-library-%{version}
%patch0 -p1

rm -r src/main/decaf/internal/util/zip
chmod 644 LICENSE.txt
chmod 644 src/main/activemq/transport/mock/MockTransport.cpp

%configure --disable-static


%build
%make_build


%install
%makeinstall_std
rm %{buildroot}%{_libdir}/lib%{name}.la
rm %{buildroot}%{_bindir}/example
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111 ! -name '*.la' `; do
	chrpath -d $i ||:
done


%check
make check




%files
%{_libdir}/lib%{name}.so.*
%doc --no-dereference LICENSE.txt
%doc NOTICE.txt README.txt RELEASE_NOTES.txt


%files devel
%{_libdir}/lib%{name}.so
%{_includedir}/%{name}-%{version}
%{_libdir}/pkgconfig/%{name}.pc
%{_bindir}/activemqcpp-config


%changelog
