Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Force out of source build
%undefine __cmake_in_source_build

Name: ampache_browser

# Lib and several dirs use this derived name. A change of this name
# is likely to break API users due to not finding files any longer.
%global vername %{name}_1

Version: 1.0.8
Release: alt1_3
Summary: C++ and Qt based client library for Ampache access

License: GPL-3.0-only
URL: http://ampache-browser.org
Source0: https://github.com/ampache-browser/ampache_browser/archive/v%{version}.tar.gz#/%{name}-%{version}.tar.gz

BuildRequires: ctest cmake
BuildRequires: gcc-c++
%if 0%{?fedora} || 0%{?rhel} >= 9
BuildRequires: qt5-base-devel qt6-base-devel
%else
BuildRequires: gcc-toolset-12
BuildRequires: qt5-base-devel
%endif
Source44: import.info

%description
Ampache Browser is a library that implements desktop client access to
the Ampache service (http://ampache.org). It provides end-user Qt UI and
has a simple C++ interface that allows easy integration into client
applications.

%package        devel
Group: Other
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%prep
%setup -q



%build
%if 0%{?rhel} == 8
. /opt/rh/gcc-toolset-12/enable
%endif

%{fedora_v2_cmake} %{?el8:-D USE_QT6=OFF} .
%fedora_v2_cmake_build


%install
%fedora_v2_cmake_install

find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'





%files
%doc --no-dereference COPYING
%doc AUTHORS NEWS README.md
%{_libdir}/lib%{vername}.so.*

%files devel
%dir %{_includedir}/%{vername}
%{_includedir}/%{vername}/%{name}/
%{_libdir}/lib%{vername}.so
%{_libdir}/pkgconfig/%{vername}.pc
%{_libdir}/cmake/%{vername}

%changelog
