Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# hardened build if not overriden
%{!?_hardened_build:%global _hardened_build 1}

%if %{?_hardened_build}%{!?_hardened_build:0}
%global cflags_harden -fpie
%global ldflags_harden -pie -z relro -z now
%endif

Summary: Routing daemon for the ampr network
Name: ampr-ripd
Version: 2.4.2
Release: alt1_2
# Automatically converted from old format: GPLv2+ - review is highly recommended.
License: GPL-2.0-or-later
URL: http://www.yo2loj.ro/hamprojects/
BuildRequires: gcc
BuildRequires: dos2unix
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd
Source0: http://www.yo2loj.ro/hamprojects/%{name}-%{version}.tgz
Source1: ampr-ripd.service
# upstream notified
Source2: COPYING
Patch0: ampr-ripd-2.4.2-install-fix.patch
Patch1: ampr-ripd-2.1.1-examples-noshebang.patch
Patch2: ampr-ripd-2.4.1-pidfile.patch
Source44: import.info

%description
Routing daemon written in C similar to Hessu's rip44d including optional
resending of RIPv2 broadcasts for router injection.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1

cp %{SOURCE2} .

%build
%make_build CFLAGS="%{optflags} %{?cflags_harden}" LDFLAGS="%{?__global_ldflags} %{?ldflags_harden}"

%install
make %{?_smp_mflags} DESTDIR=%{buildroot} SBINDIR=%{buildroot}/%{_sbindir} install

# Systemd
install -Dpm 644 %{SOURCE1} %{buildroot}%{_unitdir}/%{name}.service

# Examples
install -Dd %{buildroot}%{_datadir}/%{name}/examples
install -Dpm 644 -t %{buildroot}%{_datadir}/%{name}/examples examples/ampr-run.sh examples/find_pass.sh \
  examples/interfaces

%post
%post_service %{name}

%preun
%preun_service %{name}

%files
%doc COPYING manual.txt

%{_sbindir}/ampr-ripd
%{_datadir}/%{name}
%{_mandir}/man1/*
%{_unitdir}/%{name}.service

%changelog
