# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name arm-image-installer
%define version 3.7
# Tarfile created using git
# git clone https://pagure.io/arm-image-installer.git
# git archive --format=tar --prefix=%{name}-%{version}/ %{version} | xz > ~/%{name}-%{version}.tar.xz

Name:		arm-image-installer
Version:	3.7
Release:	alt1_2
Summary:	Writes binary image files to any specified block device
Group:          Archiving/Other
License:	GPLv2+
Url:		https://pagure.io/arm-image-installer
Source0:	%{name}-%{version}.tar.xz

BuildArch:	noarch

Requires:	btrfs-progs
Requires:	e2fsprogs
Requires:	libselinux-utils
Requires:	parted
Requires:	sudo sudo-logsrvd
Requires:	agetty cfdisk eject fdisk getopt hardlink hwclock look losetup lsblk mount msulogin rfkill schedutils setarch sfdisk shadow-change util-linux
Requires:	xfsprogs
Requires:	xz
Source44: import.info


%description
Allows one to first select a source image (local or remote). The image must be
a binary file containing: [MBR + Partitions + File Systems + Data]. A
destination block device should then be selected for final installation.

It is also suitable for dumping Mageia installer isos to USB sticks.


%prep
%setup -q
sed -i s,/usr/bin/sh,/bin/sh, rpi-uboot-update


%build
echo "skipping..."

%install
install -d %{buildroot}%{_datadir}/arm-image-installer
install -d %{buildroot}%{_datadir}/arm-image-installer/socs.d
install -pm 644 socs.d/* %{buildroot}%{_datadir}/arm-image-installer/socs.d/
install -d %{buildroot}%{_datadir}/arm-image-installer/boards.d
install -pm 644 boards.d/* %{buildroot}%{_datadir}/arm-image-installer/boards.d/

install -d %{buildroot}%{_bindir}
install -pm 0755 update-uboot %{buildroot}%{_bindir}/
install -pm 0755 arm-image-installer %{buildroot}%{_bindir}/
install -pm 0755 rpi-uboot-update %{buildroot}%{_bindir}/
install -pm 0755 spi-flashing-disk %{buildroot}%{_bindir}/
ln -s /usr/bin/arm-image-installer %{buildroot}%{_bindir}/fedora-arm-image-installer

%files
%doc --no-dereference COPYING
%doc AUTHORS README TODO SUPPORTED-BOARDS
%{_bindir}/arm-image-installer
%{_bindir}/fedora-arm-image-installer
%{_bindir}/update-uboot
%{_bindir}/rpi-uboot-update
%{_bindir}/spi-flashing-disk
%{_datadir}/arm-image-installer/


%changelog
