# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define uname   arteFetcher

Name:           artefetcher
Version:        0.8.0
Release:        alt1_4
Summary:        Fetch videos from German and French Arte+7 website
License:        GPLv3+
Group:          Video
Url:            https://sourceforge.net/projects/artefetcher
Source:         https://downloads.sf.net/artefetcher/%{name}_%{version}.tar.gz

BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5Network)
BuildRequires:  pkgconfig(Qt5Script)
BuildRequires:  pkgconfig(Qt5Widgets)
BuildRequires:  pkgconfig(Qt5XmlPatterns)
BuildRequires:  qt5-designer qt5-tools
Source44: import.info

%description
This application will list the videos available in the French-German TV channel Arte.
You can choose the movie of your choice in the list, and download it in high quality.

%prep
%setup -q -n %{name}


%build
%{_qt5_bindir}/lrelease %{uname}_de.ts %{uname}_fr.ts
%qmake_qt5
%make_build

%install
%qmakeinstall_std

gzip -d %{uname}.1.gz
install -D -m644 %{uname}.1 %{buildroot}%{_mandir}/man1/%{uname}.1

install -D -m644 img/%{uname}.png %{buildroot}%{_datadir}/pixmaps/%{uname}.png

# Write custom desktop file as the upstream one is not so good
install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{uname}.desktop
[Desktop Entry]
Name=Arte Fetcher
GenericName=Video fetcher
GenericName[fr]=Télécharger des vidéos
Comment=Get videos from Arte TV channel
Comment[fr]=Récupérez les vidéos de la chaîne Arte
Exec=arteFetcher
Icon=arteFetcher
Type=Application
Categories=AudioVideo;Video;TV;
EOF

%files
%{_bindir}/%{uname}
%{_datadir}/applications/%{uname}.desktop
%{_datadir}/pixmaps/%{uname}.png
%{_mandir}/man1/%{uname}.1*


%changelog
