# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ pkgconfig(x11)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define commit f13889496145c33abb76fa16b02edd0a1299299d

Name:    artyfx
Version: git20171104
Release: alt1_6
Summary: A LV2 plugin bundle of artistic audio effects
Group:   Sound
License: GPLv2
URL:     http://openavproductions.com/artyfx/
Source0: https://github.com/openAVproductions/openAV-ArtyFX/archive/%{commit}.tar.gz


BuildRequires: ccmake cmake ctest
BuildRequires: pkgconfig(lv2)
BuildRequires: pkgconfig(fftw3)
BuildRequires: pkgconfig(sndfile)
BuildRequires: pkgconfig(cairo)
BuildRequires: libsuil-devel

Requires: lv2-example-plugins
Requires: libsuil
Source44: import.info

%description
ArtyFX is a plugin bundle of artistic real-time audio effects. 
The aim of this plugin collection is to allow the designing of 
your sound just as you desired using a fast, efficient workflow.
From bitcrushers, delays, distortions, equalizers, compressors, 
reverbs and more, there is a range of sounds available from ArtyFX

%prep
%setup -q -n openAV-ArtyFX-%{commit}

%build

%ifarch armv7hl

sed -i -e '/CMAKE_C_FLAGS/d' ./src/avtk/CMakeLists.txt
sed -i -e '/CMAKE_CXX_FLAGS/d' ./src/avtk/CMakeLists.txt

%{mageia_cmake} -DBUILD_SSE=OFF -DBUILD_GUI=OFF

%else

%{mageia_cmake}

%endif

%make_build


%install
%makeinstall_std -C build

%ifarch x86_64
mkdir -p %{buildroot}%{_libdir}/lv2 
mv -f %{buildroot}/usr/lib/lv2/* %{buildroot}/%{_libdir}/lv2 
%endif

%files
%{_libdir}/lv2/*
%doc README.md LICENSE



%changelog
