# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: extra-cmake-modules gcc-c++ libXxf86vm-devel pkgconfig(gtkmm-3.0)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global sum     Animated sprite editor & pixel art tool

Name:           aseprite
Version:        1.1.7
Release:        alt1_8
Summary:        %{sum}
Group:          Graphics
License:        GPLv2+
URL:            www.aseprite.org
# Git repo: https://github.com/aseprite/aseprite
# Upstream zip archive repacked without unused third party libs
# rm -rf third_party/{curl,freetype2,giflib,gtest,jpeg,libpng,libwebp,libwebp-cmake,loadpng,pixman,pixman-cmake,tinyxml,zlib}
Source0:        %{name}-%{version}.tar.xz
Source1:        %{name}.1
# From third_party/pixman/pixman/pixman-combine32.h
Source2:        pixman-combine32.h
Patch0:         aseprite-1.1.4-mga-shared-gtest.patch
Patch1:         aseprite-1.1.7-allegro-no-fix-aliases.patch

BuildRequires:  liballegro-devel
BuildRequires:  ccmake cmake ctest
BuildRequires:  libgif-devel
BuildRequires:  libgtest-devel
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(libcurl)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(libwebp)
BuildRequires:  pkgconfig(pixman-1)
BuildRequires:  pkgconfig(tinyxml)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(zlib)
Source44: import.info

%description
Aseprite (aka ASE, Allegro Sprite Editor) is an open source program to
create animated sprites & pixel art. Sprites are little images that can
be used in your website or in a video game. You can draw characters with
movement, intros, textures, patterns, backgrounds, logos, color palettes,
isometric levels, etc.

%prep
%setup -q
%patch0 -p1
%patch1 -p1


# Needed to build doc-lib
mkdir -p third_party/pixman/pixman
cp %{_sourcedir}/pixman-combine32.h third_party/pixman/pixman/

# Stable version
sed -i data/gui.xml src/config.h -e 's/-dev//'

%build
# The window can't be resized/maximize when linked against the system allegro 4
# We build against the embedded version for now - patching allegro could be investigated too
# allegro is still needed as a BR for libloadpng
%{mageia_cmake} -DENABLE_UPDATER=OFF \
       -DENABLE_WEBSERVER=OFF \
       -DUSE_SHARED_ALLEGRO4=OFF \
       -DUSE_SHARED_CURL=ON \
       -DUSE_SHARED_FREETYPE=ON \
       -DUSE_SHARED_GIFLIB=ON \
       -DUSE_SHARED_GTEST=ON \
       -DUSE_SHARED_JPEGLIB=ON \
       -DUSE_SHARED_LIBPNG=ON \
       -DUSE_SHARED_LIBLOADPNG=ON \
       -DUSE_SHARED_LIBWEBP=ON \
       -DUSE_SHARED_PIXMAN=ON \
       -DUSE_SHARED_TINYXML=ON \
       -DUSE_SHARED_ZLIB=ON \
       -DWITH_WEBP_SUPPORT=ON \
       -DLIBPIXMAN_INCLUDE_DIR:PATH=%{_includedir}/pixman-1 \
       -DLIBPIXMAN_LIBRARY:FILEPATH=%{_libdir}/libpixman-1.so
%mageia_cmake_build

%install
%mageia_cmake_install

install -D -m644 %{_sourcedir}/%{name}.1 %{buildroot}%{_mandir}/man1/%{name}.1

for size in 16 32 48 64; do
  install -D -m644 data/icons/ase${size}.png \
          %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/%{name}.png
done

install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Aseprite
GenericName=Sprite editor
Comment=%{sum}
Exec=%{name}
Icon=%{name}
Type=Application
Categories=Graphics;2DGraphics;RasterGraphics;
EOF

%files
%doc CONTRIBUTING.md README.md
%{_bindir}/%{name}
%{_datadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.png
%{_mandir}/man1/%{name}.1*


%changelog
