# BEGIN SourceDeps(oneline):
BuildRequires: lzlib-devel pkgconfig(libzstd) pkgconfig(neon)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name avfs
%define major 0
%define libname lib%{name}%{major}
%define develname lib%{name}-devel

Name:           avfs
Version:        1.1.5
Release:        alt1_2
Summary:        A Virtual File System
License:        GPLv2
Group:          System/Base
Url:            https://avf.sourceforge.net/
Source0:        https://downloads.sourceforge.net/avf/%{name}-%{version}.tar.bz2
BuildRequires:  bzip2-devel
BuildRequires:  pkgconfig(fuse)
BuildRequires:  pkgconfig(liblzma)
BuildRequires:  pkgconfig(zlib)
Conflicts:      libavfs0 < 1.0.1-3
Source44: import.info

%description
AVFS is a system, which enables all programs to look inside archived or
compressed files, or access remote files without recompiling the programs
or changing the kernel.
At the moment it supports floppies, tar and gzip files, zip, bzip2, ar and
rar files, ftp sessions, http, webdav, rsh/rcp, ssh/scp. Quite a few other
handlers are implemented with the Midnight Commander's external FS.

%package -n %{libname}
Summary:        Libraries needed for %{name}
Group:          System/Libraries

%description -n %{libname}
This package contains the libraries for the %{name} virtual file system.

%package -n %{develname}
Summary:        Header files for %{name}
Group:          System/Libraries
Provides:       %{name}-devel = %{version}-%{release}
Requires:       %{libname} = %{version}-%{release}
Conflicts:      %{name} < 1.0.1-3

%description -n %{develname}
This package contains the header files needed to develop with %{name}

%prep
%setup -q

%build
%configure --with-system-zlib --with-system-bzlib --enable-fuse --enable-static=no
%make_build

%install
%makeinstall_std

find %{buildroot} -name *.la -delete

%files
%doc README AUTHORS ChangeLog NEWS
%{_bindir}/avfsd
%{_bindir}/davpass
%{_bindir}/ftppass
%{_bindir}/mountavfs
%{_bindir}/umountavfs
%{_libdir}/avfs

%files -n %{libname}
%{_libdir}/libavfs.so.%{major}
%{_libdir}/libavfs.so.%{major}.*

%files -n %{develname}
%{_bindir}/avfs-config
%{_libdir}/libavfs.so
%{_libdir}/pkgconfig/%{name}.pc
%{_includedir}/avfs.h
%{_includedir}/virtual.h


%changelog
