Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          awesfx
Version:       0.5.1c
Release:       alt2_34
Summary:       Utility programs for the AWE32/Emu10k1 sound driver
URL:           http://www.alsa-project.org/~iwai/awedrv.html
Source0:       http://ftp.suse.com/pub/people/tiwai/awesfx/awesfx-%{version}.tar.bz2
Source1:       udev-soundfont
Source2:       load-soundfont
Source3:       41-soundfont.rules
Patch0:        rename-getline-to-parseline.patch
# Automatically converted from old format: GPLv2+ - review is highly recommended.
License:       GPL-2.0-or-later

BuildRequires:  gcc
BuildRequires: libalsa-devel >= 1.0.0
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd
Source44: import.info

%description
The awesfx package contains various utility programs for controlling the 
AWE32/Emu10k1 sound driver. AWESFX includes asxfload and sfxload, the 
soundfont loaders; setfx, the chorus/reverb effect loader; aweset, a 
controller for setting parameters; and programs for converting soundfonts 
to text.

If you use an AWE32 or Emu10k1 sound driver you should install the awesfx 
package.

%prep
%setup -q

%patch0  -p1

%build
%configure CFLAGS="$RPM_OPT_FLAGS"
%make_build

%install
make DESTDIR=%{buildroot} INSTALL="install -p" install
install -Dp -m 644 %{SOURCE1} %{buildroot}%{_sysconfdir}/alsa.d/udev-soundfont
install -Dp -m 644 %{SOURCE2} %{buildroot}%{_sysconfdir}/alsa.d/load-soundfont
install -Dp -m 644 %{SOURCE3} %{buildroot}%{_udevrulesdir}/41-soundfont.rules
mkdir -p %{buildroot}%{_datadir}/soundfonts
mv %{buildroot}%{_datadir}/sounds/sf2/*.bnk %{buildroot}%{_datadir}/soundfonts
rm -rf %{buildroot}%{_datadir}/sounds
rm -f samples/Makefile*
mkdir -p %buildroot/etc/sysconfig
touch %buildroot/etc/sysconfig/awesfx

%files
%doc --no-dereference COPYING
%doc AUTHORS ChangeLog README SBKtoSF2.txt samples/README-bank samples/setfx-sample.cfg
%{_bindir}/*
%{_sysconfdir}/alsa.d
%{_udevrulesdir}/41-soundfont.rules
%{_datadir}/soundfonts/
%{_mandir}/man*/*.1*
%config(noreplace) /etc/sysconfig/awesfx

%changelog
