Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define _hardened_build 1

Name:           babeld
Version:        1.13.1
Release:        alt1_6
Summary:        Ad-hoc network routing daemon

License:        MIT
URL:            http://www.pps.univ-paris-diderot.fr/~jch/software/babel/
Source0:        http://www.pps.univ-paris-diderot.fr/~jch/software/files/%{name}-%{version}.tar.gz
Source1:        %{name}.service
Source2:        %{name}.conf
Source3:        %{name}.logrotate
BuildRequires:	libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd gcc
Conflicts:      quagga
Source44: import.info

%description
Babel is a loop-avoiding distance-vector routing protocol roughly
based on HSDV and AODV, but with provisions for link cost estimation
and redistribution of routes from other routing protocols.

%prep
%setup -q

%build
make CFLAGS="$RPM_OPT_FLAGS" %{?_smp_mflags}


%install
install -Dpm 755 babeld $RPM_BUILD_ROOT%{_sbindir}/babeld
install -Dpm 644 %{SOURCE1} $RPM_BUILD_ROOT%{_unitdir}/%{name}.service
install -Dpm 644 %{SOURCE2} $RPM_BUILD_ROOT%{_sysconfdir}/babeld.conf
install -Dpm 644 babeld.man $RPM_BUILD_ROOT/%{_mandir}/man8/babeld.8
mkdir -p $RPM_BUILD_ROOT/%{_localstatedir}/lib/
install -Dp -m 0644 %{SOURCE3} $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/babeld
for rpm404_ghost in %{_localstatedir}/lib/babel-state %{_localstatedir}/log/babel.log
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done


%post
%post_service babeld
  
%preun
%preun_service babeld

%files
%doc --no-dereference LICENCE
%doc CHANGES README
%{_sbindir}/babeld
%{_unitdir}/%{name}.service
%config(noreplace) %{_sysconfdir}/babeld.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/babeld
%{_mandir}/man8/babeld.8*
%ghost %attr(0600,root,root) %{_localstatedir}/lib/babel-state
%ghost %attr(0600,root,root) %{_localstatedir}/log/babel.log


%changelog
