# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		backuponcd
Summary:	Multi-CD backup shell scripts
Version:	0.9.1
Release:	alt1_22
License:	GPL
Group:		Archiving/Backup
URL:		http://www.tuxoncd.de/backuponcd/pub/backuponcd.html/
Source:		%{name}.tar.bz2
Patch1:		%{name}-rcmod.patch.bz2
Patch2:		%{name}-doc.patch.bz2

BuildArch:	noarch
Source44: import.info

%description
BackupOnCd is a set of shell scripts which make multi-volume backups on CD-RW
possible.  It also makes the backup faster using cdrecord in a parallel
subshell and minimizes the amount of temporary needed disk space.  Currently
supported: tar and afio.

Be sure to modify /etc/backuponcd/global.rc to suit your system!


%prep

%setup -c -q


# (pc) another dirty hack to clean out some temp files
for i in `find $RPM_BUILD_DIR/%name-%version -path '*~'`; do rm -f $i; done

# (pc) modify global.rc for more of a typical mdk setup
%patch1  -p0
# (pc) patch for documentation locations in backuponcd help message
%patch2  -p0


%install
mkdir -p %{buildroot}{%{_sbindir},%{_sysconfdir}/%{name}}
cp $RPM_BUILD_DIR/%name-%version/usr/local/sbin/* %{buildroot}%{_sbindir}
cp $RPM_BUILD_DIR/%name-%version/etc/%{name}/global.rc %{buildroot}%{_sysconfdir}/%{name}
cp $RPM_BUILD_DIR/%name-%version/usr/doc/%{name}/samples/excludelist %{buildroot}%{_sysconfdir}/%{name}

chmod 755 %{buildroot}%{_sbindir}/*


%files
%doc usr/doc/backuponcd/*
%{_sbindir}/*
%dir %{_sysconfdir}/%{name}
%attr(644,root,root) %config(noreplace) %{_sysconfdir}/%{name}/global.rc
%config(noreplace) %{_sysconfdir}/%{name}/excludelist






%changelog
