Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install /usr/bin/gettext /usr/bin/tidy gcc-c++ libSDL-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           ballerburg
Version:        1.2.3
Release:        alt1_3
Summary:        Two players, two castles, and a hill in between

License:        GPL-3.0-or-later
URL:            https://baller.frama.io/
Source0:        https://framagit.org/baller/ballerburg/-/archive/v%{version}/%{name}-v%{version}.tar.gz
Source1:        https://baller.frama.io/king.png
Source2:        %{name}.desktop
Source3:        %{name}.appdata.xml

Patch:          ballerburg-1.2.3-Fix_depends.patch

BuildRequires:  gcc
BuildRequires:  ctest cmake
BuildRequires:  libSDL2-devel libSDL2-devel-static
BuildRequires:  gettext-tools
BuildRequires:  ImageMagick-tools
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  desktop-file-utils
Requires:       icon-theme-hicolor
Source44: import.info


%description
Two castles, separated by a mountain, try to defeat each other with their
cannonballs, either by killing the opponent's king or by weakening the
opponent enough so that the king capitulates.

Ballerburg was originally written 1987 by Eckhard Kruse, for the Atari ST
machines (which were brand new computers at that point in time). Over 25
years later, here's finally the adaption of the original source code to
modern operating systems.


%prep
%setup -q -n %{name}-v%{version}
%patch0 -p1



%build
%{fedora_v2_cmake}
%fedora_v2_cmake_build


%install
%fedora_v2_cmake_install

# Install additional docs
install -p -m 644 LIESMICH.txt README.txt doc/authors.txt \
  %{buildroot}%{_docdir}/%{name}

# Install icons
for px in 32 48 64 256; do
  mkdir -p %{buildroot}%{_datadir}/icons/hicolor/${px}x${px}/apps
  magick %{SOURCE1} \
    -gravity south \
    -resize ${px}x${px} \
    -extent ${px}x${px} \
    -background white \
    %{buildroot}%{_datadir}/icons/hicolor/${px}x${px}/apps/%{name}.png
done

# Install desktop file
desktop-file-install \
  --dir=%{buildroot}%{_datadir}/applications \
  %{SOURCE2}

# Install appdata
install -d %{buildroot}%{_datadir}/metainfo
install -p -m 0644 %{SOURCE3} \
  %{buildroot}%{_datadir}/metainfo
appstream-util validate-relax --nonet \
  %{buildroot}%{_datadir}/metainfo/%{name}.appdata.xml


%find_lang %{name}


%files -f %{name}.lang
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_mandir}/man6/ballerburg.6*
%{_datadir}/metainfo/%{name}.appdata.xml
%{_datadir}/applications/*.desktop
%{_datadir}/icons/hicolor/*/apps/*
%doc %{_docdir}/%{name}
%doc --no-dereference COPYING.txt


%changelog
