# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
Name:           bamf-qt
Version:        0.2.3

Release:        alt1_3
Summary:        Qt bindings and QML plugin for Bamf DBus server

Group:          System/Libraries
# LGPLv3 only as upstream does not install GPLv3 example
License:        LGPLv3
URL:            https://launchpad.net/bamf-qt/

# there's currently no standalone upstream release
Source0:        https://launchpad.net/ubuntu/precise/+source/libqtbamf/0.2.3-0ubuntu1/+files/libqtbamf_%{version}.orig.tar.gz

Patch0:         bamf-qt-0.1.bzr371-libdir-suffix.patch

BuildRequires:  bamf-devel
BuildRequires:  qt4-devel
BuildRequires: ctest cmake
Source44: import.info


%description
%{summary}.

%package devel
Group:    Development/C
Summary:  Development files for %{name}
Requires: %{name} = %{version}-%{release}
%description devel
Header files for developing applications using %{name}.

%prep
%setup -q -n libqtbamf-%{version}

# install pkgconfig and QML plugin to correctly suffixed libdir
%patch0 -p1 -b .libdir-suffix

%build
mkdir -p %{_target_platform}
pushd %{_target_platform}
%{fedora_cmake} ..
popd
make %{?_smp_mflags}  -C %{_target_platform}


%install
make install/fast DESTDIR=%{buildroot} -C %{_target_platform}


%files
%doc README COPYING-GPL3 COPYING-LGPL3
%{_libdir}/libQtBamf.so.*
%{_qt4_importdir}/bamf

%files devel
%{_includedir}/QtBamf 
%{_libdir}/libQtBamf.so
%{_libdir}/pkgconfig/libqtbamf.pc

%changelog
