# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-python3
# END SourceDeps(oneline)
Group: Development/C
BuildRequires: /usr/bin/pod2man
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       beakerlib
Summary:    A shell-level integration testing library
Version:    1.27
Release:    alt1_2
License:    GPLv2
BuildArch:  noarch
URL:        https://github.com/%{name}
Autoreq:    0
Requires:   nfs-clients nfs-server nfs-stats nfs-utils
Requires:   /bin/bash
Requires:   /bin/sh
%if 0%{?fedora}
Requires: /usr/bin/python3
%endif
%if 0%{?rhel} < 8
Requires:   /usr/bin/perl
Requires:   wget
Requires:   python3-module-lxml
Requires:   /usr/bin/xmllint
%else
# rhel > 7 and fedora
Requires: /usr/bin/perl
Requires:   wget
Requires: python3-module-lxml
Requires: /usr/bin/xmllint
%endif
Requires:   grep
Requires:   sed
Requires:   arpd iproute2
Requires:   coreutils
Requires:   tar
Requires:   gzip gzip-utils
Requires:   cfdisk eject fdisk getopt hwclock look lsblk msulogin rfkill setarch sfdisk util-linux
Requires:   which
%if 0%{?fedora}
#Requires:   dnf-utils
%else
#Requires:   yum-utils
%endif
Requires:   /usr/bin/bc
Requires:   /usr/bin/time

BuildRequires: /usr/bin/pod2man
BuildRequires: rpm-build-perl
BuildRequires: cfdisk eject fdisk getopt hwclock look lsblk msulogin rfkill setarch sfdisk util-linux

Source0:    https://github.com/beakerlib/beakerlib/archive/%{name}-%{version}.tar.gz
Source1:    %{name}-tmpfiles.conf

Patch0: bugzilla-links.patch
Patch1: bugzilla-links-epel.patch
Patch2: python3.patch
Patch3: python-platform.patch
Source44: import.info

%prep
%setup -q

%if 0%{?fedora}
# Patch0: bugzilla-links.patch
%patch0 -p1
%else
# rhel
# Patch1: bugzilla-links-epel.patch
%patch1 -p1
%endif

%if 0%{?fedora}
# Patch2: python3.patch
%patch2 -p1
%endif
%if 0%{?rhel} > 7
# Patch3: python-platform.patch
%patch3 -p1
%endif


%build
make build

%install
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}
%{!?_tmpfilesdir: %global _tmpfilesdir %{_tmpfilesdir}/}
make PKGDOCDIR=%{_docdir}/%{name} DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT/%{_tmpfilesdir}
install -m 0644 %{SOURCE1} $RPM_BUILD_ROOT/%{_tmpfilesdir}/%{name}.conf

%description
The BeakerLib project means to provide a library of various helpers, which
could be used when writing operating system level integration tests.

%files
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/xslt-templates
%dir %{_docdir}/%{name}
%dir %{_docdir}/%{name}/examples
%dir %{_docdir}/%{name}/examples/*
%{_datadir}/%{name}/dictionary.vim
%{_datadir}/%{name}/*.sh
%{_datadir}/%{name}/xslt-templates/*
%{_bindir}/%{name}-*
%{_mandir}/man1/%{name}*1*
%doc %{_docdir}/%{name}/*
%config %{_tmpfilesdir}/%{name}.conf

%package vim-syntax
Group: Development/C
Summary: Files for syntax highlighting BeakerLib tests in VIM editor
Requires: xxd
BuildRequires: xxd

%description vim-syntax
Files for syntax highlighting BeakerLib tests in VIM editor

%files vim-syntax
%{_datadir}/vim/vimfiles/after/ftdetect/beakerlib.vim
%{_datadir}/vim/vimfiles/after/syntax/beakerlib.vim

%changelog
