Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: swig
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
BuildRequires: /usr/bin/git
%define autorelease 33

Name:         bicon
License:      LGPL-2.0-or-later and Python-2.0.1
Version:      0.5
Release:      alt2_%autorelease
Summary:      Bidirectional Console
Source:       https://github.com/behdad/bicon/releases/download/%{version}/%{name}-%{version}.tar.gz
Patch0:       %{name}-HEAD.patch
URL:          https://www.arabeyes.org/Bicon

BuildRequires: autoconf
BuildRequires: automake
BuildRequires: libfribidi-devel
BuildRequires: git
BuildRequires: console-vt-tools kbd kbdrate vlock
BuildRequires: libtool
Requires:      console-vt-tools kbd kbdrate vlock
Requires:      setxkbmap
Requires:      xkbcomp
Source44: import.info

%description
BiCon is the bidirectional console as presented by Arabeyes.

%package devel
Group: Other
Summary:        Development Libraries for BiCon
Requires:       %{name} = %{version}-%{release}

%description devel
The bicon-devel package contains the libraries and header files
that are needed for writing applications with BiCon.

%package fonts
Group: Other
Summary:        Font Files for BiCon
Requires:       %{name} = %{version}-%{release}
BuildArch:      noarch

%description fonts
The bicon-fonts package contains the font files for BiCon.

%package keymaps
Group: Other
Summary:        Keymap Files for BiCon
Requires:       %{name} = %{version}-%{release}
BuildArch:      noarch

%description keymaps
The bicon-keymaps package contains the keymap files for BiCon.

%prep
%setup -q
git init -q
git config user.name "rpmbuild"
git config user.email "<rpmbuild>"
git config gc.auto 0
git add --force .
git commit -q --allow-empty -a --author "rpmbuild <rpmbuild>" -m "%{NAME}-%{VERSION} base"
cat %_sourcedir/%{name}-HEAD.patch | git apply --index --reject  -
git commit -q -m %{name}-HEAD.patch --author "rpmbuild <rpmbuild>"


%build
libtoolize
autoreconf --verbose --force --install
%configure \
  --disable-static
%make_build

%install
make DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p" install

rm -f $RPM_BUILD_ROOT%{_libdir}/bicon/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/bicon/*.a

%files
%doc AUTHORS COPYING README
%{_bindir}/*
%{_libdir}/bicon/*.so.*
%dir %{_datadir}/%{name}
%{_datadir}/man/man1/**

%files devel
%{_includedir}/*
%{_libdir}/bicon/*.so
%{_libdir}/pkgconfig/*.pc

%files fonts
%{_datadir}/%{name}/font

%files keymaps
%{_datadir}/%{name}/keymap

%changelog
