# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ perl(IPC/Open2.pm)
# END SourceDeps(oneline)
Name:           boolstuff
Version:        0.1.13
Release:        alt1_2
Summary:        Disjunctive Normal Form boolean expression library
Group:          System/Libraries

License:        GPLv2+
URL:            http://perso.b2b2c.ca/sarrazip/dev/boolstuff.html
Source0:        http://perso.b2b2c.ca/sarrazip/dev/boolstuff-%{version}.tar.gz

# To remove the date from the doxygen footers, use a footer file done after
# doxygen -w html header.html footer.html stylesheet.css
# and edition (with version doxygen-1.5.2-1.fc7).
# date is removed to have the same files for multilib installations
Patch0:         boolstuff-0.1.11-footer.patch
Source1:        boolstuff-no_date_footer.html


# for testcases
BuildRequires:  perl
# for api documentation
BuildRequires:  doxygen
Source44: import.info


%description
This library contains an algorithm that converts a boolean expression
binary tree into the Disjunctive Normal Form.  The NOT operator
is supported.

%description    -l fr
Cette librairie contient un algorithme qui convertit une expression
booléenne sous forme d'arbre binaire en sa forme normale disjonctive.
L'opérateur de négation est supporté.


%package        devel
Summary:        Development files for %{name}
Group:          Development/C
Requires:       %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%description    devel -l fr
Ce paquetage contient les bibliothèques et fichiers d'en-tête
permettant de développer des applications avec %{name}.


%package        -n booldnf
Summary:        Disjunctive Normal Form boolean expression command-line
Group:          Development/Tools
Requires:       %{name} = %{version}-%{release}

%description    -n booldnf
booldnf is a program that reads boolean expressions from its standard
input and rewrites them in Disjunctive Normal Form on its standard output.  
It uses the BoolStuff library.

%description    -n booldnf -l fr
booldnf est un programme qui lit une expression booléenne depuis l'entrée
standard et la réécrit sur la sortie standard en forme normale disjonctive. 
Cette commande utilise la bibliothèque BoolStuff.


%prep
%setup -q
%patch0 -p1 -b .footer
cp -p %{SOURCE1} src/boolstuff/no_date_footer.html

%build
%configure
make %{?_smp_mflags}
pushd src/boolstuff
make doc
popd


%install
# we install the doc files in a temporary directory we remove immediatly
# since the doc files are in main package %doc
make install DESTDIR=$RPM_BUILD_ROOT docdir=%{_datadir}/tmpdocdir INSTALL="%{__install} -p"
rm -rf $RPM_BUILD_ROOT%{_datadir}/tmpdocdir

rm $RPM_BUILD_ROOT%{_libdir}/libboolstuff-*.la

rm -rf __dist_docs
mkdir __dist_docs
cp -pR src/boolstuff/html __dist_docs/api-html
# fix the timestamp of the generated docs such that it is the same on all
# architectures
touch -r NEWS __dist_docs/api-html/*
cp -pR examples/ __dist_docs/
mv __dist_docs/examples/test-booldnf.pl __dist_docs/
chmod a-x __dist_docs/test-booldnf.pl
rm -rf __dist_docs/examples/Makefile* __dist_docs/examples/.deps


%check
make check


%files
%doc THANKS README COPYING NEWS AUTHORS TODO
%{_libdir}/*.so.*


%files -n booldnf
%doc __dist_docs/test-booldnf.pl
%{_bindir}/booldnf
%{_mandir}/man1/booldnf.1*


%files devel
%doc __dist_docs/examples __dist_docs/api-html
%{_includedir}/boolstuff*/
%{_libdir}/*.so
%{_mandir}/man3/boolstuff.3*
%{_libdir}/pkgconfig/boolstuff-0.1.pc


%changelog
