# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		brainparty
Version:	0.61
Release:	alt1_11
Summary:	Set of 36 minigames to train your brain in an entertaining way
Group:		Games/Puzzles
# Music files are CC-BY-SA 3.0 or CC-BY-ND 3.0 or Soundsnap License: https://www.soundsnap.com/licence
License:	GPLv3+
URL:		https://www.tuxradar.com/brainparty
Source0:	https://launchpad.net/brainparty/trunk/%{version}/+download/%{name}%{version}.tar.gz
Patch0:		brainparty-0.61-mga-datadir.patch
Patch1:		brainparty-0.61-linking.patch
Patch2:		brainparty-0.61-mga-configfile.patch
# Fix from https://bugs.launchpad.net/brainparty/+bug/1272279
Patch3:		brainparty-0.61-gcc-4.9-default-argument.patch
Patch4:		brainparty-gcc7.patch
Patch5:		brainparty-fix-build-with-gcc15.patch

BuildRequires:	ImageMagick-tools libImageMagick7.10
BuildRequires:	pkgconfig(sdl)
BuildRequires:	pkgconfig(SDL_gfx)
BuildRequires:	pkgconfig(SDL_image)
BuildRequires:	pkgconfig(SDL_mixer)
BuildRequires:	pkgconfig(SDL_ttf)
Source44: import.info

%description
Brain Party is a fun, free puzzle game for all the family that's made up
of 36 minigames designed to push your brain to its limits by testing
memory, logic, mathematics, reaction time and more! Brain Party is split
into two modes: test mode gives you five minigames in a row and adds up
your brain weight to see how smart you are, and practise mode lets you
play your favourite minigames as often as you want.

%prep
%setup -q -n %{name}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1


#use our build flags
sed -i -e 's|\(CXXFLAGS =\).*|\1 -c -Wno-deprecated %{optflags} -std=gnu++11|g' Makefile
sed -i -e '/CXXFLAGS =/ i \\tLDFLAGS = ' Makefile

%build
%make_build

# Desktop entry
cat > %{name}.desktop << EOF
[Desktop Entry]
Name=Brain Party
Comment=Fun brain training with 36 minigames
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;LogicGame;
EOF

%install
install -D -m0755 %{name} %{buildroot}%{_gamesbindir}/%{name}
mkdir -p %{buildroot}%{_gamesdatadir}/%{name}
install -m0644 Content/* %{buildroot}%{_gamesdatadir}/%{name}/
install -D -m0755 %{name}.desktop %{buildroot}%{_datadir}/applications/%{name}.desktop

for size in 16 32 64; do
    convert ./Content/icon.bmp -resize ${size}x${size} %{name}-${size}.png
    install -D -m0644 %{name}-${size}.png %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/%{name}.png
done

%files
%doc CREDITS README
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_iconsdir}/hicolor/*/apps/%{name}.png


%changelog
