# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: /usr/bin/doxygen boost-devel gcc-c++ libcurl-devel perl(DBD/SQLite.pm) perl(DBI.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          brewtarget
Version:       3.0.9
Release:       alt1_1
Summary:       An open source beer recipe creation tool
Group:         Sciences/Other
License:       GPLv3 and WTFPL and LGPLv2
URL:           http://www.brewtarget.org
Source0:       https://github.com/Brewtarget/brewtarget/archive/v%{version}/%{name}-%{version}.tar.gz
Patch0:        fix_boost_requirements.patch
BuildRequires: ccmake cmake ctest
BuildRequires: pkgconfig(sqlite3)
BuildRequires: pkgconfig(xalan-c)
BuildRequires: boost-complete
BuildRequires: sqlite3
BuildRequires: pkgconfig(Qt5Core)
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5Help)
BuildRequires: pkgconfig(Qt5Multimedia)
BuildRequires: pkgconfig(Qt5PrintSupport)
BuildRequires: pkgconfig(Qt5Qml)
BuildRequires: pkgconfig(Qt5Sql)
BuildRequires: pkgconfig(Qt5Svg)
BuildRequires: pkgconfig(Qt5Test)
BuildRequires: pkgconfig(Qt5Widgets)
BuildRequires: pkgconfig(Qt5Xml)
Source44: import.info

%description
Brewtarget is an open source beer recipe creation tool. It automatically
calculates color, bitterness, and other parameters for you while you drag and
drop ingredients into the recipe. Brewtarget also has many other tools such as
priming sugar calculators, OG correction help, and a unique mash designing tool.
It also can export and import recipes in BeerXML.

%prep
%setup -q
%patch0 -p1


%build
%{mageia_cmake} -DDO_RELEASE_BUILD:BOOL=ON
%mageia_cmake_build

%install
%mageia_cmake_install

# Remove generated files. We use what's provided in tarball.
rm %{buildroot}%{_docdir}/%{name}/{RelaseNotes.markdown,changelog.Debian.gz,copyright}
gzip doc/brewtarget.1
install -m 0644 -Dp doc/brewtarget.1.gz %{buildroot}%{_mandir}/man1/brewtarget.1.gz
# symlink manual, which is accessible in application
rm %{buildroot}%{_datadir}/%{name}/manual-en.pdf
pushd %{buildroot}%{_datadir}/%{name}
ln -s ../doc/%{name}-%{version}/manual-en.pdf .
popd

%files
%doc CHANGES.markdown README.markdown doc/manual-en.pdf
%doc --no-dereference COPYRIGHT COPYING.GPLv3 COPYING.WTFPL
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg
%{_mandir}/man1/brewtarget.1*


%changelog
