# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           brogue
Version:        1.14
Release:        alt1_2
Summary:        Roguelike game that favors simplicity over complexity
Group:          Games/Arcade
License:        AGPLv3
URL:            https://sites.google.com/site/broguegame/
Source0:        https://github.com/tmewett/BrogueCE/archive/refs/tags/v%{version}/%{name}-%{version}.tar.gz
Source1:        brogue-wrapper.sh
Patch1:         0001-Fix-clang-error-with-incompatible-function-pointer-types.patch

BuildRequires:  pkgconfig(ncurses)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_image)
BuildRequires:  pkgconfig(zlib)
Source44: import.info

%description
Brogue is a direct descendant of Rogue, unlike other popular modern
roguelikes, and it favors simplicity over complexity, while trying
to ensure that the interactions between components will be interesting
and varied.

It is possible to play entirely with the keyboard or entirely with
the mouse or a combination of the two as the player chooses.

Brogue can be played either with a libtcod/SDL or a ncurses interface.
See `brogue --help' for more information.

%prep
%setup -q -n BrogueCE-%{version}
%patch1 -p1


cp bin/keymap.txt bin/keymap

%build
%make_build DATADIR=%{_gamesdatadir}/%{name} \
            RELEASE=YES \
            DEBUG=YES \
            TERMINAL=YES \
            CFLAGS="%{optflags}" \
            LDFLAGS=""
%install
# Launch game via a wrapper script and install binary in %%_libexecdir
install -D -m755 bin/%{name} %{buildroot}%{_libexecdir}/%{name}/%{name}

install -D -m755 %{SOURCE1} %{buildroot}%{_gamesbindir}/%{name}

# Install data files
install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a bin/assets/ \
      bin/keymap \
      %{buildroot}%{_gamesdatadir}/%{name}/

# Icon and desktop entry
install -D -m644 bin/assets/icon.png %{buildroot}%{_iconsdir}/hicolor/256x256/apps/%{name}.png

install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Brogue
GenericName=Roguelike
Comment=Brave the Dungeons of Doom!
Exec=%{name}
Icon=%{name}
Type=Application
Categories=Game;RolePlaying;
Terminal=false
EOF

%files
%doc CHANGELOG.md README.md
%doc --no-dereference LICENSE.txt
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_iconsdir}/hicolor/256x256/apps/%{name}.png
%dir %{_libexecdir}/%{name}
%{_libexecdir}/%{name}/%{name}


%changelog
