# BEGIN SourceDeps(oneline):
BuildRequires: libSDL-devel libjpeg-devel
# END SourceDeps(oneline)
BuildRequires: zlib-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		bumprace
Epoch:		1
Version:	1.5.8
Release:	alt1_3
Summary:	Drive the ship to exit
Group:		Games/Arcade
License:	GPLv2+
URL:		https://www.linux-games.com/bumprace
# From repo: https://bitbucket.org/karlb/bumprace
Source0:	https://github.com/karlb/bumprace/archive/%{version}/%{name}-%{version}.tar.gz
Source1:	%{name}-16.png
Source2:	%{name}-32.png
Source3:	%{name}-48.png
Patch0:		%{name}-fix-build-with-gcc15.patch
BuildRequires:	pkgconfig(SDL_mixer)
BuildRequires:	pkgconfig(SDL_image)
Source44: import.info

%description
BumpRace is a simple arcade game. You've to get from the start to the finish
line without crashing into deadly blocks. This game is really easy to learn!

%prep
%setup -q
%patch0 -p1


# Fix version tag
sed -i -e 's/1\.5\.3/%{version}/' configure.ac src/bumprace.c

%build
autoreconf -vfi
%configure --bindir=%{_gamesbindir} --datadir=%{_gamesdatadir}
%make_build

%install
%makeinstall_std

mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Encoding=UTF-8
Name=Bumprace
Comment=Drive the ship to exit
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;ArcadeGame;
EOF

install -D -m644 %SOURCE1 %{buildroot}%_niconsdir/%{name}.png
install -D -m644 %SOURCE2 %{buildroot}%{_miconsdir}/%{name}.png
install -D -m644 %SOURCE3 %{buildroot}%{_liconsdir}/%{name}.png

%files
%doc AUTHORS FAQ NEWS README
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%_niconsdir/%{name}.png
%{_miconsdir}/%{name}.png
%{_liconsdir}/%{name}.png


%changelog
