Group: Office
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define alphatag 20211220cvs

Summary: Reminder utility
Name:    calendar
Version: 1.37
Release: alt2_7.%{alphatag}
License: BSD
URL:     http://www.openbsd.org/cgi-bin/cvsweb/src/usr.bin/calendar

# The source archive is generated with the export-calendar-source.sh
# script.  Update the script's TAG variable when a new version of
# OpenBSD is released.  The version number we use for the calendar
# program is the CVS revision ID of the calendar.c file.  This is
# determined by the script so it can make the source archive.
Source0: %{name}-%{version}-%{alphatag}.tar.gz
Source1: Makefile.linux
Source2: export-calendar-source.sh

Patch0:  %{name}-1.37-linux.patch

BuildRequires: gcc
Requires: cpp
Source44: import.info

%description
The OpenBSD calendar command is a reminder utility.  Calendar reads
a mix of configuration files and standard calendar databases and
then displays lines that begin with either today's date or
tomorrow's.  The output of the command shows upcoming events for the
week.

%prep
%setup -q -n %{name}-%{version}-%{alphatag}
%patch0 -p1 -b .orig
cp %{SOURCE1} Makefile

for c in calendars/*.*/* ; do
    fromcode="$(grep '^LANG=' "$c" | sed 's/^LANG=\(.*\)\.\(.*\)\(@.*\)\{0,1\}/\2/')"
    if [ ! -z "$fromcode" ]; then
        iconv -f "$fromcode" -t "UTF-8" "$c" > "$c.conv"
        mv "$c.conv" "$c"
    fi
done

%build
%make_build

%install
make install DESTDIR=%{buildroot}

%files
%attr(755,root,root) %{_bindir}/calendar
%{_mandir}/man1/calendar.1*
%{_datadir}/calendar

%changelog
