# BEGIN SourceDeps(oneline):
BuildRequires: imake libICE-devel libSM-devel libX11-devel libXt-devel libopenmotif-devel xorg-cf-files zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define sum Desktop background manager/changer/screensaver

Summary:	%{sum}
Name:		chbg
Version:	2.0.1
Release:	alt2_32
License:	GPLv2+
Group:		Graphics
URL:		https://www.beebgames.com/sw/gtk-ports.html
Source0:	https://www.beebgames.com/sw/%{name}-%{version}.tar.bz2
Source1:	%{name}_16x16.png
Source2:	%{name}_32x32.png
Source3:	%{name}_48x48.png
Source4:	%{name}-%{version}-po.tar.bz2
# (fc) 2.0.1-3mdv use correct colormap / depth 
Patch0:		chbg-2.0.1-colormap.patch
# (fc) 2.0.1-9mdv fix CFLAGS
Patch1:		chbg-2.0.1-cflags.patch
Patch2:		chbg-2.0.1-libpng1.5.patch
Patch3:		chbg-2.0.1-link.patch
Patch4:		chbg-2.0.1-langs.patch
BuildRequires:	gettext-tools libasprintf-devel
BuildRequires:	pkgconfig(atk)
BuildRequires:	pkgconfig(gtk+-2.0)
BuildRequires:	pkgconfig(libpng)
Source44: import.info

%description
ChBg is for changing desktop backgrounds in a given period. It can
render images with 10 modes (such as tiled, centered, scaled, etc.). It
uses gdk_pixbuf-2.0 for loading images, so it supports
many image formats. 
ChBg has a windowed setup program, is able to load setup files, 
can be used as slideshow picture previewer in its own window or as a
desktop background, and can be used as screensaver or as an xscreensaver
hack. It has a dialog for fast previewing of pictures and very usable
thumbnail previews.

%prep
%setup -q
%patch0  -p1 -b .composite
%patch1  -p1 -b .cflags
%patch2  -p0 -b .libpng
%patch3  -p0 -b .link
%patch4  -p1 -b .langs
tar -xf %{SOURCE4}

%build
%global optflags %(echo "%{optflags} -Wno-incompatible-pointer-types -Wno-int-conversion -std=gnu17")

autoreconf -fi
%configure \
    --with-intl-includes=%{_datadir}/gettext/intl
%make_build

%install
%makeinstall_std

# install icons
mkdir -p %{buildroot}%{_iconsdir}/hicolor/{16x16,32x32,48x48}/apps
install -m 644 %{SOURCE1} %{buildroot}%{_iconsdir}/hicolor/16x16/apps/%{name}.png
install -m 644 %{SOURCE2} %{buildroot}%{_iconsdir}/hicolor/32x32/apps/%{name}.png
install -m 644 %{SOURCE3} %{buildroot}%{_iconsdir}/hicolor/48x48/apps/%{name}.png

# menu stuff
mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=ChBg
GenericName=Changer of background
GenericName[ru]=Сменщик фона
Comment=%{sum}
Comment[ru]=ChBg - менеджер рабочего стола/сменщик/заставка
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
StartupNotify=true
Categories=Settings;
NotShowIn=GNOME;KDE;
EOF

# touch the default sysconfig file so that it can be included
mkdir -p %{buildroot}%{_sysconfdir}
touch %{buildroot}%{_sysconfdir}/chbgrc

%{find_lang} %{name}

%files -f %{name}.lang
%doc AUTHORS BUGS ChangeLog README THANKS TODO chbgrc.sample xscreensaver*txt 
%{_bindir}/chbg
%{_datadir}/applications/*.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.png
%{_mandir}/man*/*
%attr(644,root,root) %config(noreplace,missingok) %{_sysconfdir}/chbgrc


%changelog
