# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ libssl-devel qt5-base-devel zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 1.6.2
%define url_ver	%(echo %{version}|sed 's/[.]/./g')

Name:		chessx
Version:	1.6.2
Release:	alt1_2
Summary:	An Open Source chess database
License:	GPLv2
Group:		Games/Boards
URL:		https://chessx.sourceforge.io/
Source0:	https://sourceforge.net/projects/chessx/files/%{name}/%{version}/%{name}-%{url_ver}.tgz
# upstream patches
# https://github.com/Isarhamster/chessx/pull/61
Patch002:	0002-Fix-install-path-of-icons-on-Linux.patch
# https://github.com/Isarhamster/chessx/pull/63
Patch003:	0003-Allow-linking-against-system-libraries-via-pkg-confi.patch
# mageia patches
Patch10:	chessx-mga-install-lang-and-data-files.patch

BuildRequires:	qt6-5compat-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-tools-devel
BuildRequires:	qt6-multimedia-devel
BuildRequires:	qt6-multimedia-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-svg-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-speech-devel
BuildRequires:	qt6-base-devel
BuildRequires:	qt6-base-devel
BuildRequires:	pkgconfig(quazip1-qt6)

# Bundles part of scid 1.0 (https://sourceforge.net/projects/scid/)
Provides:	bundled(scid) = 1.0
Source44: import.info

%description
ChessX is an Open Source chess database. With ChessX you can operate on your
collection of chess games in many ways:
browse, edit, add, organize, analyze, etc.

%prep
%setup -q -n %{name}-master
%patch2 -p1
%patch3 -p1
%patch10 -p1


# Ensure bundled quazip code is not used
rm -rf src/quazip

%build
%{_qt6_bindir}/lrelease i18n/*.ts
%qmake_qt6 -r CONFIG+=link_pkgconfig CONFIG+=speech
%make_build

%install
%makeinstall_std INSTALL_ROOT=%{buildroot}

%files
%doc --no-dereference COPYING.md
%doc README.md ChangeLog.md
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.png
%{_metainfodir}/io.sourceforge.ChessX.metainfo.xml


%changelog
