# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           clanbomber
Version:        2.1.1
Release:        alt6_41
Summary:        A free (GPL) Bomberman-like multiplayer game
License:        GPLv2
Group:          Games/Arcade
URL:		https://savannah.nongnu.org/projects/clanbomber/
Source0:        https://download.savannah.gnu.org/releases/clanbomber/%{name}-%{version}.tar.lzma
Source11:	%{name}.16.png
Source12:	%{name}.32.png
Source13:	%{name}.48.png
Patch0:		clanbomber-2.1.1-desktop-fix.patch
Patch1:		clanbomber-2.1.1-dirprefix.patch
Patch2:		clanbomber-2.1.1-mageia-boost-filesystem.patch
Patch3:		gcc7-fixes.patch
Patch4:		clanbomber-2.1.1-boost-1.87.0.patch
BuildRequires:	boost-complete
BuildRequires:	pkgconfig(sdl) >= 1.2.0
BuildRequires:	pkgconfig(SDL_image)
BuildRequires:	pkgconfig(SDL_mixer)
BuildRequires:	pkgconfig(SDL_ttf)
BuildRequires:	pkgconfig(SDL_gfx)
BuildRequires:	gettext-tools libasprintf-devel
Source44: import.info

%description
ClanBomber is a free (GPL) Bomberman-like multiplayer game that uses ClanLib, a
free multi platform C++ game SDK. First "ClanBomber" was only a working title
for a small game started in September 1998, that has only been started to learn
how to use ClanLib. But the ClanBomber project has grown into a real game. It
is fully playable and features Computer controlled bombers, however, it is
recommended to play ClanBomber with friends (3-8 players are really fun).

%prep
%setup -q
%patch0
%patch1
%patch2
%patch3
%patch4


# make autoreconf happy
sed -i -e 's,dist-lzma,subdir-objects,' -e 's,-Werror,,' configure.ac

%build
%add_optflags -Wno-error=return-type
# fix build on aarch64
autoreconf -vfi

export CXXFLAGS="%optflags -pthread"
%configure --bindir=%{_gamesbindir} \
           --datadir=%{_gamesdatadir} \
           --with-boost-libdir=%{_libdir}
%make_build

%install
%makeinstall_std

%find_lang %name

install -m644 %{SOURCE11} -D %{buildroot}%{_miconsdir}/%{name}.png
install -m644 %{SOURCE12} -D %{buildroot}%_niconsdir/%{name}.png
install -m644 %{SOURCE13} -D %{buildroot}%{_liconsdir}/%{name}.png

mkdir -p %{buildroot}%{_datadir}/applications
mv %{buildroot}%{_gamesdatadir}/applications/*.desktop %{buildroot}%{_datadir}/applications/
rm -rf %{buildroot}%{_gamesdatadir}/applications

%files -f %name.lang
%doc AUTHORS README
%doc --no-dereference COPYING
%{_gamesbindir}/*
%{_gamesdatadir}/%{name}/
%{_miconsdir}/%{name}.png
%_niconsdir/%{name}.png
%{_liconsdir}/%{name}.png
%{_datadir}/applications/*.desktop


%changelog
