Group: Graphical desktop/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global         main_ver      1.4.5
%global         vendor_rel    4

%global         reponame      ClipIt
%global         gitdate       20210513
%global         gitcommit     e5fa64c216c1b02a43cb3c90e8a151e43e881d96
%global         shortcommit   %(c=%{gitcommit}; echo ${c:0:7})

%global         tarballdate   20210922
%global         tarballtime   1754

%global         use_release   0
%global         use_gitbare  1
%global         use_gitcommit_as_rel  1

%if 0%{?use_gitbare} < 1
%global         use_release   1
%endif

%if 0%{?use_gitcommit_as_rel} >= 1
%global         rel           %{vendor_rel}.D%{gitdate}git%{shortcommit}%{?dist}
%else
%define         rel           %{vendor_rel}%{?dist}
%endif


Name:           clipit
Version:        %{main_ver}
Release:        alt1_%{rel}.5
Summary:        A lightweight, fully featured GTK+ clipboard manager

License:        GPLv3+
URL:            https://github.com/CristianHenzel/ClipIt
%if 0%{?use_release} >= 1
Source0:        https://github.com/CristianHenzel/ClipIt/archive/v%{version}.tar.gz
%else
Source0:        %{reponame}-%{tarballdate}T%{tarballtime}.tar.gz
%endif
Source1:        %{name}.appdata.xml
# clipit doesn't autostart in MATE
# Fixed upstream but not yet merged
Patch0:         0001-Autostart-in-MATE.patch
# Force GDK_BACKEND to x11
Patch1:         clipit-1.4.5-force-gdk_backend-x11.patch
Patch2:         clipit-c99.patch

%if 0%{?use_gitbare} >= 1
BuildRequires:  git
%endif
BuildRequires:  automake
BuildRequires:  gcc
BuildRequires:  pkgconfig(gtk+-3.0)
BuildRequires:  desktop-file-utils
BuildRequires:  intltool
BuildRequires:  gettext-tools
BuildRequires:  %{_bindir}/appstream-util
Requires:       xdotool
Source44: import.info

%description
ClipIt is a lightweight, fully featured GTK+ clipboard manager. It was forked
from Parcellite, adding additional features and bug-fixes to the project.
ClipIts main features are:
* Save a history of your last copied items
* Search through the history
* Global hot-keys for most used functions
* Execute actions with clipboard items
* Exclude specific items from history


%prep
%if 0%{?use_release} >= 1
%setup -q -n %{reponame}-%{version}
%endif

%if 0%{?use_gitbare} >= 1
%setup -q -c -T -a 0
git clone ./%{reponame}.git

cd %{reponame}
git checkout -b fedora-%{version}-head %{gitcommit}
cp -a [A-Z]* ..

git config user.name "%{name} Fedora maintainer"
git config user.email "%{name}-maintainer@fedoraproject.org"
%endif

%patch0 -p1 -b .mate
%patch1 -p1 -b .nowayland
%patch2 -p1

sed -i data/clipit.desktop.in -e '\@_Comment.*hr@d'
sed -i data/clipit-startup.desktop.in -e '\@_Comment.*hr@d'

%if 0%{?use_gitbare} >= 1
git commit -m "Apply Fedora specific configuration" -a
%endif

./autogen.sh

%build
%if 0%{?use_gitbare} >= 1
cd %{reponame}
%endif

%configure \
	--with-gtk3 \
	%{nil}
%make_build

%install
%if 0%{?use_gitbare} >= 1
cd %{reponame}
%endif

%makeinstall_std

%if 0%{?use_gitbare} >= 1
cd ..
%endif

%find_lang %{name}

desktop-file-install --delete-original \
    --remove-category=Application \
    --dir %{buildroot}%{_datadir}/applications \
    %{buildroot}%{_datadir}/applications/%{name}.desktop

desktop-file-install --delete-original \
    --dir %{buildroot}%{_sysconfdir}/xdg/autostart \
    %{buildroot}%{_sysconfdir}/xdg/autostart/%{name}-startup.desktop

mkdir -p %{buildroot}%{_metainfodir}
install -c -p -m 644 %{SOURCE1} %{buildroot}%{_metainfodir}/%{name}.appdata.xml

%check
appstream-util validate-relax --nonet %{buildroot}%{_metainfodir}/%{name}.appdata.xml

%files -f %{name}.lang
%doc --no-dereference COPYING
%doc AUTHORS
%doc ChangeLog
%doc README.md

%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*
%{_datadir}/icons/hicolor/scalable/apps/%{name}-trayicon*.svg
%{_metainfodir}/%{name}.appdata.xml

%{_datadir}/applications/%{name}.desktop
%config(noreplace) %{_sysconfdir}/xdg/autostart/%{name}-startup.desktop

%changelog
