Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python rpm-build-python3
BuildRequires: python-devel
# END SourceDeps(oneline)
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fontpkgname clustershell
%if 0%{?fedora} >= 22
%{!?python2_pkgversion: %global python2_pkgversion 2}
%global python2_pkgprefix python%{python2_pkgversion}
%else
%global python2_pkgprefix python
%endif

%if 0%{?rhel}
%{!?python3_pkgversion: %global python3_pkgversion 34}
%else
%{!?python3_pkgversion: %global python3_pkgversion 3}
%endif
%global python3_pkgprefix python%{python3_pkgversion}

# Undefined in SUSE
%{!?__python3: %global __python3 python3}
%{!?python3_shortver: %global python3_shortver %(%{__python3} -c 'import sys; print(str(sys.version_info.major) + "." + str(sys.version_info.minor))')}

# Only build python3 package?
%if 0%{?rhel} >= 8 || 0%{?fedora} >= 31
%global py3only 1
%endif

%global srcname ClusterShell

Name:           clustershell
Version:        1.8.3
Release:        alt2_8
Summary:        Python framework for efficient cluster administration

%if 0%{?suse_version}
License:        LGPL-2.1
%else
License:        LGPLv2+
%endif
URL:            http://cea-hpc.github.io/clustershell/
Source0:        https://github.com/cea-hpc/clustershell/archive/v%{version}/%{srcname}-%{version}.tar.gz
BuildArch:      noarch
%if 0%{!?py3only:1}
Requires:       python-module-%{name} = %{version}-%{release}
%else
Requires:       python3-module-clustershell = %{version}-%{release}
%endif
%if 0%{?rhel} >= 7 || 0%{?fedora}
%else
%if 0%{?suse_version}
Requires:       vim-common vimtutor
BuildRequires:  vim-common vimtutor
%else
Requires:       xxd
%endif
%endif
Provides:       vim-clustershell = %{version}-%{release}
Obsoletes:      vim-clustershell < 1.7.81-4
Source44: import.info

%description
ClusterShell is a set of tools and a Python library to execute commands
on cluster nodes in parallel depending on selected engine and worker
mechanisms. Advanced node sets and node groups handling methods are provided
to ease and improve the daily administration of large compute clusters or
server farms. Command line utilities like clush, clubak and nodeset (or
cluset) allow traditional shell scripts to take benefit of the features
offered by the library.


%if 0%{!?py3only:1}
%package -n python-module-clustershell
Group: System/Base
Summary:        ClusterShell module for Python 2
BuildRequires:  python3-devel
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
Requires:       python3-module-pkg_resources python3-module-setuptools
%if 0%{?suse_version}
Requires:       %{python2_pkgprefix}-PyYAML
%else
Requires:       python-module-yaml
%endif
%{?python_provide:%python_provide python2-%{name}}

%description -n python-module-clustershell
ClusterShell Python 2 module and related command line tools.
%endif


%package -n python3-module-clustershell
Group: System/Base
Summary:        ClusterShell module for Python 3
BuildRequires:  %{python3_pkgprefix}-devel
BuildRequires:  python3-module-distribute
Requires:       python3-module-yaml
Requires:       python3-module-distribute
%{?python_provide:%python_provide %{python3_pkgprefix}-%{srcname}}

%description -n python3-module-clustershell
ClusterShell Python 3 module and related command line tools.


%prep
%setup -q -n %{srcname}-%{version}

%build
%{__python3} setup.py build
%if 0%{!?py3only:1}
%{__python} setup.py build
%endif

%install
%{__python3} setup.py install -O1 --skip-build --root %{buildroot}

%if 0%{!?py3only:1}
pushd %{buildroot}%{_bindir}
for i in clubak cluset clush nodeset; do
  mv $i $i-%{python3_shortver}
done
popd

%{__python} setup.py install -O1 --skip-build --root %{buildroot}
%endif

# move config dir away from default setuptools /usr prefix (if rpm-building as user)
[ -d %{buildroot}/usr/etc ] && mv %{buildroot}/usr/etc %{buildroot}/%{_sysconfdir}

%if 0%{?rhel} && 0%{?rhel} <= 6
# old versions of rpm (el5 and el6) requires that a file/link exists in buildroot
# even when ghosted, but it is not installed at the end...
ln -s conf/groups.d/local.cfg %{buildroot}/%{_sysconfdir}/clustershell/groups
%endif

# man pages
install -d %{buildroot}/%{_mandir}/{man1,man5}
install -p -m 0644 doc/man/man1/clubak.1 %{buildroot}/%{_mandir}/man1/
install -p -m 0644 doc/man/man1/cluset.1 %{buildroot}/%{_mandir}/man1/
install -p -m 0644 doc/man/man1/clush.1 %{buildroot}/%{_mandir}/man1/
install -p -m 0644 doc/man/man1/nodeset.1 %{buildroot}/%{_mandir}/man1/
install -p -m 0644 doc/man/man5/clush.conf.5 %{buildroot}/%{_mandir}/man5/
install -p -m 0644 doc/man/man5/groups.conf.5 %{buildroot}/%{_mandir}/man5/

# vim addons
%if 0%{?suse_version}
%define vimdatadir %{_datadir}/vim/site
%else
%define vimdatadir %{_datadir}/vim/vimfiles
%endif

install -d %{buildroot}/%{vimdatadir}/{ftdetect,syntax}
install -p -m 0644 doc/extras/vim/ftdetect/clustershell.vim %{buildroot}/%{vimdatadir}/ftdetect/
install -p -m 0644 doc/extras/vim/syntax/clushconf.vim %{buildroot}/%{vimdatadir}/syntax/
install -p -m 0644 doc/extras/vim/syntax/groupsconf.vim %{buildroot}/%{vimdatadir}/syntax/
for rpm404_ghost in %{_sysconfdir}/clustershell/groups
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done


%if 0%{!?py3only:1}

%files -n python-module-clustershell
%if 0%{?rhel}
%endif
%{_bindir}/clubak
%{_bindir}/cluset
%{_bindir}/clush
%{_bindir}/nodeset
%{python_sitelibdir_noarch}/ClusterShell/
%{python_sitelibdir_noarch}/ClusterShell-*-py?.?.egg-info

%files -n python3-module-clustershell
%if 0%{?rhel}
%endif
%{_bindir}/clubak-%{python3_shortver}
%{_bindir}/cluset-%{python3_shortver}
%{_bindir}/clush-%{python3_shortver}
%{_bindir}/nodeset-%{python3_shortver}
%{python3_sitelibdir_noarch}/ClusterShell/
%{python3_sitelibdir_noarch}/ClusterShell-*-py%{__python3_version}.egg-info

%else

# Unversioned python3 tools for rhel8

%files -n python3-module-clustershell
%if 0%{?rhel}
%endif
%{_bindir}/clubak
%{_bindir}/cluset
%{_bindir}/clush
%{_bindir}/nodeset
%{python3_sitelibdir_noarch}/ClusterShell/
%{python3_sitelibdir_noarch}/ClusterShell-*-py%{__python3_version}.egg-info

%endif

%files
%if 0%{?rhel}
%endif
%doc ChangeLog COPYING.LGPLv2.1 README.md
%doc doc/examples
%doc doc/sphinx
%{_mandir}/man1/clubak.1*
%{_mandir}/man1/cluset.1*
%{_mandir}/man1/clush.1*
%{_mandir}/man1/nodeset.1*
%{_mandir}/man5/clush.conf.5*
%{_mandir}/man5/groups.conf.5*
%dir %{_sysconfdir}/clustershell
%dir %{_sysconfdir}/clustershell/groups.d
%dir %{_sysconfdir}/clustershell/groups.conf.d
%config(noreplace) %{_sysconfdir}/clustershell/clush.conf
%config(noreplace) %{_sysconfdir}/clustershell/groups.conf
%ghost %{_sysconfdir}/clustershell/groups
%config(noreplace) %{_sysconfdir}/clustershell/groups.d/local.cfg
%doc %{_sysconfdir}/clustershell/groups.conf.d/README
%doc %{_sysconfdir}/clustershell/groups.conf.d/*.conf.example
%doc %{_sysconfdir}/clustershell/groups.d/README
%doc %{_sysconfdir}/clustershell/groups.d/*.yaml.example
%doc %{_sysconfdir}/clustershell/topology.conf.example
%{vimdatadir}/ftdetect/clustershell.vim
%{vimdatadir}/syntax/clushconf.vim
%{vimdatadir}/syntax/groupsconf.vim

%changelog
