# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name clutter-imcontext
%define version 0.1.6
# Tarfile created using git
# git clone git://git.moblin.org/clutter-imcontext
# git archive --format=tar --prefix=%{name}-%{version}/ %{git_version} | bzip2 > ~/%{name}-%{version}-%{gitdate}.tar.bz2
%define git_version 9043ff1
%define tarfile %{name}-%{version}.tar.bz2

%define major		0
%define api		0.1
%define libname		lib%{name}%{api}_%{major}
%define develname	lib%{name}-devel

Name:		clutter-imcontext
Version:	0.1.6
Release:	alt1_14
Summary:	IMContext Framework Library for Clutter
Group:		System/Libraries
License:	LGPLv2
URL:		http://www.moblin.org/
Source0:	%{tarfile}
BuildRequires:	glib2-devel
BuildRequires:	libclutter-devel libclutter-gir-devel
BuildRequires:	gtk-doc
Source44: import.info

%description
IMContext Framework Library for Clutter.

%package -n %{libname}
Summary:	Runtime library for %{name}
Group:		System/Libraries
Requires:	%{name} >= %{version}-%{release}

%description -n %{libname}
Runtime library for %{name}.

%package -n %{develname}
Summary:	Development files and headers for %{name}
Group:		Development/C
Provides:	%{name}-devel = %{version}-%{release}
Provides:	lib%{name}-devel = %{version}-%{release}
Provides:	%{_lib}clutter-imcontext%{api}-devel = %{version}-%{release}
Requires:	%{libname} = %{version}-%{release}
Obsoletes:	%{_lib}clutter-imcontext0.1-devel < 0.1.6-6

%description -n %{develname}
Files for development with %{name}.

%package docs
Summary:	Documentation package for %{name}
Group:		Development/C
BuildArch:	noarch

%description docs
Documentation for development with %{name}.

%prep
%setup -q

%build
# Don't run configure from autogen.sh
sed -i -e '/configure/d' autogen.sh
./autogen.sh

%configure \
        --enable-gtk-doc \
	--disable-static

%make_build

%install
%makeinstall_std

#Remove libtool archives.
find %{buildroot} -name '*.la' -delete

%files
%dir %{_sysconfdir}/clutter-imcontext
%config %{_sysconfdir}/clutter-imcontext/enable_autoshow
%{_bindir}/clutter-scan-immodules

%files -n %{libname}
%doc AUTHORS ChangeLog
%{_libdir}/lib%{name}-%{api}.so.%{major}*

%files -n %{develname}
%{_includedir}/%{name}-%{api}
%{_libdir}/pkgconfig/%{name}-%{api}.pc
%{_libdir}/lib%{name}-%{api}.so

%files docs
%doc %{_datadir}/gtk-doc/html/%{name}


%changelog
