Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires: libglibmm-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	C++ interface for Clutter
Name:		cluttermm
Version:	1.17.3
Release:	alt2_27
# Automatically converted from old format: LGPLv2+ - review is highly recommended.
License:	LicenseRef-Callaway-LGPLv2+
URL:		http://www.gtkmm.org/
Source0:	http://download.gnome.org/sources/cluttermm/1.17/%{name}-%{version}.tar.xz

BuildRequires:  gcc-c++
BuildRequires:	libatkmm-devel
BuildRequires:	libclutter-devel libclutter-gir-devel
BuildRequires:	libgtkmm3-devel
BuildRequires:	libpangomm-devel
Source44: import.info

%description
Cluttermm is a C++ interface for Clutter: a software library for creating
fast, visually rich graphical user interfaces.

%package	devel
Group: Development/Other
Summary:	Development files for %{name}
Requires:	%{name} = %{version}-%{release}

%description devel
This package contains development files for %{name}.

%package	doc
Group: Documentation
Summary:	API documentation for %{name}
BuildArch:	noarch
Requires:	%{name} = %{version}-%{release}

%description doc
This package contains the full API documentation for %{name}.

%prep
%setup -q

%build
%configure --disable-silent-rules

# Omit unused direct shared library dependencies.
sed --in-place --expression 's! -shared ! -Wl,--as-needed\0!g' libtool

%make_build

%install
make install INSTALL="install -p" DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name "*.la" -delete



%files
%doc COPYING NEWS
%{_libdir}/libcluttermm-1.0.so.*

%files devel
%doc examples/actor.png
%doc examples/test-actors.cc
%doc examples/test-boxes.cc
%{_libdir}/libcluttermm-1.0.so
%{_libdir}/pkgconfig/%{name}-1.0.pc
%{_libdir}/%{name}-1.0
%{_datadir}/%{name}-1.0
%{_includedir}/%{name}-1.0

%files doc
%doc %{_docdir}/cluttermm-1.0/
%doc %{_datadir}/devhelp/

%changelog
