# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define oname	ColorCode

Name:		colorcode
Version:	0.8.7
Release:	alt1_2
Summary:	Advanced MasterMind clone
License:	GPLv3+
Group:		Games/Puzzles
URL:		http://colorcode.laebisch.com/
Source0:	http://colorcode.laebisch.com/download/%{oname}-%{version}.tar.gz
Source1:	%{name}.6

BuildRequires:	ccmake cmake ctest
BuildRequires:	pkgconfig(Qt5Core)
BuildRequires:	pkgconfig(Qt5Gui)
BuildRequires:	pkgconfig(Qt5Help)
BuildRequires:	pkgconfig(Qt5Widgets)
Source44: import.info


%description
ColorCode is an advanced MasterMind code-breaking game clone. The program 
accepts setting the number of slots (from 2 to 5), the number of colors 
(from 2 to 10) and setting if colors might be repeated in the secret code 
(doubles allowed or not). The game has 5 built-in levels, from 
level 1 (beginner: 2 slots and 2 colors, with doubles allowed) 
to level 5 (hard: 5 slots and 10 colors, with doubles allowed). 
ColorCode can make guesses in place of the user.


%prep
%setup -q -n %{oname}-%{version}


%build
%{mageia_cmake_qt5} -S ./src
%mageia_cmake_build

%install
install -m 755 %{_vpath_builddir}/%{name} -D %{buildroot}%{_gamesbindir}/%{name}
install -m 644 %{SOURCE1} -D %{buildroot}%{_mandir}/man6/%{name}.6

for size in 16 32 64; do
  install -D -m 644 src/img/cc${size}.png %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/%{name}.png
done

install -d %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=ColorCode
Comment=Advanced clone of the MasterMind code-breaking game
GenericName=Advanced MasterMind clone
GenericName[fr]=Clone avancé du jeu MasterMind
GenericName[nb_NO]=Avansert MasterMind-klone
GenericName[nn]=Avansert MasterMind-klone
Exec=%{_gamesbindir}/%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;LogicGame;
EOF


%files
%doc src/changelog
%doc --no-dereference COPYING
%{_gamesbindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.png
%{_mandir}/man6/%{name}.6*


%changelog
