Group: System/Base
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:               conman
Version:            0.3.1
Release:            alt1_6
Summary:            ConMan - The Console Manager

# GPLv3+, but strlc*.c is under ISC
License:            GPL-3.0-or-later AND ISC
URL:                https://dun.github.io/conman/
Source0:            https://github.com/dun/%{name}/archive/%{name}-%{version}.tar.gz#/%{name}-%{version}.tar.gz

Requires:           logrotate
BuildRequires:      gcc
BuildRequires:      rpm-build-perl
BuildRequires:      libfreeipmi-devel
BuildRequires:      libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd
BuildRequires:      autoconf automake libtool
Source44: import.info

%description
ConMan is a serial console management program designed to support a large
number of console devices and simultaneous users.  It currently supports
local serial devices and remote terminal servers (via the telnet protocol).
Its features include:

  - mapping symbolic names to console devices
  - logging all output from a console device to file
  - supporting monitor (R/O), interactive (R/W), and
    broadcast (W/O) modes of console access
  - allowing clients to join or steal console "write" privileges
  - executing Expect scripts across multiple consoles in parallel


%prep
%setup -q -n %{name}-%{name}-%{version}


sh ./bootstrap


%build
%configure
%make_build


%install
%makeinstall_std

# make log directories
mkdir -p %{buildroot}%{_localstatedir}/log/%{name}
mkdir -p %{buildroot}%{_localstatedir}/log/%{name}.old


%post
%post_service conman

%preun
%preun_service conman

%files
%doc --no-dereference COPYING
%doc AUTHORS FAQ NEWS
%config(noreplace) %{_sysconfdir}/%{name}.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}
%{_unitdir}/%{name}.service
%dir %{_localstatedir}/log/%{name}
%dir %{_localstatedir}/log/%{name}.old
%{_bindir}/conman
%{_bindir}/conmen
%{_sbindir}/conmand
%{_datadir}/%{name}/
%{_mandir}/man1/conman.*
%{_mandir}/man5/conman.conf.*
%{_mandir}/man8/conmand.*


%changelog
