Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:   Password cracker
Name:      crack
Version:   5.0a
Release:   alt3_45
License:   Artistic clarified
Source:    ftp://ftp.cerias.purdue.edu/pub/tools/unix/pwdutils/crack/%{name}5.0.tar.gz
Patch0:    %{name}-chris.patch
Patch1:    %{name}-FHS.patch
URL:       https://dropsafe.crypticide.com/alecm/software/crack/c50-faq.html
BuildRequires: words, gawk, gcc
Source44: import.info

%description
Crack is a password guessing program that is designed to quickly locate
insecurities in Unix (or other) password files by scanning the contents of a
password file, looking for users who have misguidedly chosen a weak login
password.

This package creates a group named "crack" and the Crack program puts all
its results in the /var/lib/crack/run directory, which belongs to that group.
Only users in the crack group can use this package.


%prep
%setup -q -n c50a
# Make sure we do not use libdes
rm -rf src/libdes
# select proper crypt routine and related checks
rm -f src/util/elcid.c
ln src/util/elcid.c,bsd src/util/elcid.c
mkdir run bin
# Try not to pollute bin namespace
sed -i -e 's/Reporter/CrackReporter/g' doc/gui.txt manual.html manual.txt
%patch0 -p1 -b .chris
sed -i 's|/usr/dict/|/usr/share/dict/|g' conf/dictgrps.conf
# Alter script to use FHS layout
%patch1 -p1 -b .FHS

%build
%global build_type_safety_c 0
C5FLAGS="-D_XOPEN_SOURCE -DUSE_STRING_H -DUSE_STDLIB_H -DUSE_SIGNAL_H -DUSE_SYS_TYPES_H -DUSE_UNISTD_H -DUSE_PWD_H"
make XDIR=../../bin XCC=gcc XCFLAGS="$RPM_OPT_FLAGS $C5FLAGS" XLIBS=-lcrypt utils
CRACK_HOME=`pwd` CRACK_BIN_HOME=`pwd` CRACK_STATE_DIR=`pwd` ./Crack -makedict


%install
rm -f bin/libc5.a bin/stdlib-cracker
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}
mkdir -p $RPM_BUILD_ROOT%{_libexecdir}/%{name}
mkdir -p $RPM_BUILD_ROOT%{_sharedstatedir}/%{name}
cp -a bin $RPM_BUILD_ROOT%{_libexecdir}/%{name} 
cp -a conf dict scripts $RPM_BUILD_ROOT%{_datadir}/%{name}
cp -a run $RPM_BUILD_ROOT%{_sharedstatedir}/%{name}
install -p -m0755 Crack $RPM_BUILD_ROOT%{_bindir}/Crack
install -p -m0755 Reporter $RPM_BUILD_ROOT%{_bindir}/CrackReporter



%pre
if [ $1 -eq 1 ]; then
    groupadd -r crack >/dev/null 2>&1 || :
fi


%files
%doc LICENCE manual.* doc
%attr(00750, root, crack) %{_bindir}/Crack*
%{_libexecdir}/%{name}/
%{_datadir}/%{name}/
%dir %{_sharedstatedir}/%{name}/
%attr(02770, root, crack) %dir %{_sharedstatedir}/%{name}/run/
%attr(02770, root, crack) %dir %{_sharedstatedir}/%{name}/run/dict/
%attr(00640, root, crack) %{_sharedstatedir}/%{name}/run/dict/*
%attr(00640, root, crack) %{_sharedstatedir}/%{name}/run/dict/.dictmade


%changelog
