# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global sum	A game about the interactions within a gardening community
%define Name    Cultivation

Name:		cultivation
Version:	9
Release:	alt1_19
Summary:	%{sum}
License:	Public Domain
Group:		Games/Strategy
URL:		https://cultivation.sourceforge.net/
Source0:	https://sourceforge.net/projects/cultivation/files/cultivation/v9/Cultivation_%{version}_UnixSource.tar.gz
Patch0:		Cultivation-9-deb-portaudio.patch
Patch1:		Cultivation-9-deb-portaudio19.patch
Patch2:		Cultivation-9-deb-math_h.patch
Patch3:		Cultivation-9-upstream-fix_crash.patch
#Patch4:		Cultivation-9-mageia-build64bit.patch
BuildRequires:	pkgconfig(glu)
BuildRequires:	pkgconfig(freeglut)
BuildRequires:	libportaudio2-devel
BuildRequires:	pkgconfig(libpng)
BuildRequires:	ImageMagick-tools libImageMagick7.10
Requires:	soundwrapper
Source44: import.info

%description
Cultivation is a game about a community of gardeners growing food
for themselves in a shared space.

Cultivation is quite different from most other games. It is a
social simulation, and the primary form of conflict is over land
and plant resources --- there is no shooting, but there are plenty
of angry looks. It is also an evolution simulation. Within the
world of Cultivation, you can explore a virtually infinite
spectrum of different plant and gardener varieties.

All of the graphics, sounds, melodies,and other content in
Cultivation are 100% procedurally generated at playtime. In other
words, there are no hand-painted texture maps --- instead, each
object has a uniquely 'grown' appearance. Every time you play,
Cultivation generates fresh visuals, music, and behaviors.


%prep
%setup -q -n %{Name}_%{version}_UnixSource
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1


%build

export CFLAGS="$RPM_OPT_FLAGS -fPIC -DPIC"
pushd game2
	chmod u+x configure
	./configure --linux
popd
	convert -type Grayscale -negate ./game2/build/macOSX/icon128_mask.png mask.png
	composite -compose CopyOpacity mask.png ./game2/build/macOSX/icon128_color.png cultivation.png
	mkdir -p 32x32
	convert -scale 32x32 cultivation.png 32x32/cultivation.png
	convert 32x32/cultivation.png 32x32/cultivation.xpm
	sed -i -e 's/-lX11//' game2/gameSource/Makefile
	sed -i -e 's/^DEBUG_FLAG = .*/DEBUG_FLAG = /' game2/gameSource/Makefile
	sed -i -e 's/^OPTIMIZE_FLAG = .*/OPTIMIZE_FLAG = /' game2/gameSource/Makefile
	sed -i -e 's/^COMPILE_FLAGS = /COMPILE_FLAGS = ${CFLAGS} /' game2/gameSource/Makefile
echo zzzz
	make %{?_smp_mflags} -C game2/gameSource CFLAGS="${CFLAGS} -DDATADIR=\"%{_gamesdatadir}/%{name}\""


%install
install -d -m 755 %{buildroot}%{_gamesbindir}
install -m 755 game2/gameSource/%{Name} \
	%{buildroot}%{_gamesbindir}/%{name}.real

install -d -m 755 %{buildroot}%{_gamesdatadir}/%{name}
install -m 644 game2/gameSource/font.tga \
	%{buildroot}%{_gamesdatadir}/%{name}
install -m 644 game2/gameSource/features.txt \
	%{buildroot}%{_gamesdatadir}/%{name}
install -m 644 game2/gameSource/language.txt \
	%{buildroot}%{_gamesdatadir}/%{name}
install -d -m 755 %{buildroot}%{_gamesdatadir}/%{name}/languages
install -m 644 game2/gameSource/languages/*.txt \
	%{buildroot}%{_gamesdatadir}/%{name}/languages

# startscript
cat > %{buildroot}%{_gamesbindir}/%{name} <<'EOF'
#!/bin/bash
if [ ! -d $HOME/.%{name} ]; then
	mkdir -p $HOME/.%{name}
	cd $HOME/.%{name}
	cp %{_gamesdatadir}/%{name}/*.txt .
	ln -s %{_gamesdatadir}/%{name}/*.tga .
	ln -s %{_gamesdatadir}/%{name}/languages .
	ln -s %{_gamesbindir}/%{name}.real .
fi

cd $HOME/.%{name}

# Basic switch of language according to locale defined in Unix systems
case "$LC_MESSAGES" in
    fr* )
        language="French"
	;;
    pt* )
        language="Portuguese"
	;;
    * )
        language="English"
	;;
esac
echo $language > ./language.txt

./%{name}.real
EOF
chmod 755 %{buildroot}%{_gamesbindir}/%{name}

# icon
install -d -m 755 %{buildroot}%{_datadir}/pixmaps
install -m 644 cultivation.png %{buildroot}%{_datadir}/pixmaps/%{name}.png

mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=%{name}
Comment=%{sum}
Exec=soundwrapper %{name}
Icon=%{name}
Terminal=false
Type=Application
StartupNotify=true
Categories=Game;Simulation;
EOF

%files
%doc game2/documentation/*
%{_gamesbindir}/%{name}
%{_gamesbindir}/%{name}.real
%{_gamesdatadir}/%{name}
%{_datadir}/applications/*.desktop
%{_datadir}/pixmaps/%{name}.png


%changelog
