# BEGIN SourceDeps(oneline):
BuildRequires: gem-pg-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           cw
Version:        1.0.16
Release:        alt1_10
Summary:        Non-intrusive real-time ANSI color wrapper for common commands
License:        GPLv2+
Group:          Development/Other
URL:            http://cwrapper.sourceforge.net/
Source0:        http://cwrapper.sourceforge.net/%{name}-%{version}.tar.bz2
Patch0:		cw-1.0.16-cflags.patch
Patch1:		cw-1.0.16-format.patch
Source44: import.info

%description
cw is a non-intrusive real-time ANSI color wrapper for common Unix-based
commands on GNU/Linux. cw is designed to simulate the environment of the
commands being executed, so that if a person types 'du', 'df', 'ping',
etc. in their shell it will automatically color the output in real-time
according to a definition file containing the color format desired. cw
has support for wildcard match coloring, tokenized coloring,
headers/footers, case scenario coloring, command line dependent
definition coloring, and includes over 50 pre-made definition files.


%prep
%setup -q
%patch0 -p1
%patch1 -p1


/usr/bin/perl -pi -e 's/ -o 0 -g 0//g' Makefile.in
/usr/bin/perl -pi -e 's|/usr/local/lib|%{_datadir}|g' README
# STREAMS support is gone from glibc 2.31
/usr/bin/perl -pi -e 's/isastream\([[:alnum:]]*\)/0/' src/*.c


%build
autoreconf -fi
%configure
%make_build LIBDIR=%{_datadir} local

%install
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_datadir}
mkdir -p %{buildroot}%{_mandir}/man1
make install PREFIX=%{buildroot}%{_prefix} LIBDIR=%{buildroot}%{_datadir} MANDIR=%{buildroot}%{_mandir}
rm %{buildroot}%{_bindir}/cwe
ln -s cw %{buildroot}%{_bindir}/cwe

/usr/bin/perl -pi -e 's|CWLIB=.*|CWLIB="%{_datadir}/%{name}"|g' %{buildroot}%{_bindir}/colorcfg
/usr/bin/perl -pi -e 's|%{buildroot}||g' %{buildroot}%{_datadir}/%{name}/*

%files
%doc CHANGES CONTRIB cw.lsm FILES MD5SUM README
%{_bindir}/*
%{_datadir}/%{name}
%{_mandir}/man1/*


%changelog
